/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.AbstractTableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.AggregateMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.DirectedGraph;
import com.simba.cassandra.shaded.datastax.driver.core.FunctionMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.MaterializedViewMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.shaded.datastax.driver.core.ReplicationStrategy;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.SimpleJSONParser;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.TupleType;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.shaded.datastax.driver.core.VersionNumber;
import com.simba.cassandra.shaded.google.common.annotations.VisibleForTesting;
import com.simba.cassandra.shaded.google.common.collect.ImmutableSortedSet;
import com.simba.cassandra.shaded.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyspaceMetadata {
    public static final String KS_NAME = "keyspace_name";
    private static final String DURABLE_WRITES = "durable_writes";
    private static final String STRATEGY_CLASS = "strategy_class";
    private static final String STRATEGY_OPTIONS = "strategy_options";
    private static final String REPLICATION = "replication";
    private final String name;
    private final boolean durableWrites;
    private final boolean virtual;
    private final ReplicationStrategy strategy;
    private final Map<String, String> replication;
    final Map<String, TableMetadata> tables = new ConcurrentHashMap<String, TableMetadata>();
    final Map<String, MaterializedViewMetadata> views = new ConcurrentHashMap<String, MaterializedViewMetadata>();
    final Map<String, UserType> userTypes = Collections.synchronizedMap(new LinkedHashMap());
    final Map<String, FunctionMetadata> functions = new ConcurrentHashMap<String, FunctionMetadata>();
    final Map<String, AggregateMetadata> aggregates = new ConcurrentHashMap<String, AggregateMetadata>();
    private static final Comparator<UserType> typeByName = new Comparator<UserType>(){

        @Override
        public int compare(UserType o1, UserType o2) {
            return o1.getTypeName().compareTo(o2.getTypeName());
        }
    };
    private static final Comparator<FunctionMetadata> functionByName = new Comparator<FunctionMetadata>(){

        @Override
        public int compare(FunctionMetadata o1, FunctionMetadata o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    };
    private static final Comparator<AggregateMetadata> aggregateByName = new Comparator<AggregateMetadata>(){

        @Override
        public int compare(AggregateMetadata o1, AggregateMetadata o2) {
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    };

    @Deprecated
    @VisibleForTesting
    KeyspaceMetadata(String name, boolean durableWrites, Map<String, String> replication) {
        this(name, durableWrites, replication, false);
    }

    @VisibleForTesting
    KeyspaceMetadata(String name, boolean durableWrites, Map<String, String> replication, boolean virtual) {
        this.name = name;
        this.durableWrites = durableWrites;
        this.replication = replication;
        this.strategy = ReplicationStrategy.create(replication);
        this.virtual = virtual;
    }

    static KeyspaceMetadata build(Row row, VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() <= 2) {
            String name = row.getString(KS_NAME);
            boolean durableWrites = row.getBool(DURABLE_WRITES);
            HashMap<String, String> replicationOptions = new HashMap<String, String>();
            replicationOptions.put("class", row.getString(STRATEGY_CLASS));
            replicationOptions.putAll(SimpleJSONParser.parseStringMap(row.getString(STRATEGY_OPTIONS)));
            return new KeyspaceMetadata(name, durableWrites, replicationOptions, false);
        }
        String name = row.getString(KS_NAME);
        boolean durableWrites = row.getBool(DURABLE_WRITES);
        return new KeyspaceMetadata(name, durableWrites, row.getMap(REPLICATION, String.class, String.class), false);
    }

    static KeyspaceMetadata buildVirtual(Row row, VersionNumber cassandraVersion) {
        String name = row.getString(KS_NAME);
        return new KeyspaceMetadata(name, false, Collections.<String, String>emptyMap(), true);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public Map<String, String> getReplication() {
        return Collections.unmodifiableMap(this.replication);
    }

    public TableMetadata getTable(String name) {
        return this.tables.get(Metadata.handleId(name));
    }

    TableMetadata removeTable(String table) {
        return this.tables.remove(table);
    }

    public Collection<TableMetadata> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public MaterializedViewMetadata getMaterializedView(String name) {
        return this.views.get(Metadata.handleId(name));
    }

    MaterializedViewMetadata removeMaterializedView(String materializedView) {
        return this.views.remove(materializedView);
    }

    public Collection<MaterializedViewMetadata> getMaterializedViews() {
        return Collections.unmodifiableCollection(this.views.values());
    }

    public UserType getUserType(String name) {
        return this.userTypes.get(Metadata.handleId(name));
    }

    public Collection<UserType> getUserTypes() {
        return Collections.unmodifiableCollection(this.userTypes.values());
    }

    UserType removeUserType(String userType) {
        return this.userTypes.remove(userType);
    }

    public FunctionMetadata getFunction(String name, Collection<DataType> argumentTypes) {
        return this.functions.get(Metadata.fullFunctionName(Metadata.handleId(name), argumentTypes));
    }

    public FunctionMetadata getFunction(String name, DataType ... argumentTypes) {
        return this.getFunction(name, Lists.newArrayList(argumentTypes));
    }

    public Collection<FunctionMetadata> getFunctions() {
        return Collections.unmodifiableCollection(this.functions.values());
    }

    FunctionMetadata removeFunction(String fullName) {
        return this.functions.remove(fullName);
    }

    public AggregateMetadata getAggregate(String name, Collection<DataType> argumentTypes) {
        return this.aggregates.get(Metadata.fullFunctionName(Metadata.handleId(name), argumentTypes));
    }

    public AggregateMetadata getAggregate(String name, DataType ... argumentTypes) {
        return this.getAggregate(name, Lists.newArrayList(argumentTypes));
    }

    public Collection<AggregateMetadata> getAggregates() {
        return Collections.unmodifiableCollection(this.aggregates.values());
    }

    AggregateMetadata removeAggregate(String fullName) {
        return this.aggregates.remove(fullName);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery()).append('\n');
        for (UserType udt : this.getSortedUserTypes()) {
            sb.append('\n').append(udt.exportAsString()).append('\n');
        }
        for (AbstractTableMetadata tm : ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(AbstractTableMetadata.byNameComparator).addAll(this.tables.values())).build()) {
            sb.append('\n').append(tm.exportAsString()).append('\n');
        }
        for (FunctionMetadata fm : ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(functionByName).addAll(this.functions.values())).build()) {
            sb.append('\n').append(fm.exportAsString()).append('\n');
        }
        for (AggregateMetadata am : ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(aggregateByName).addAll(this.aggregates.values())).build()) {
            sb.append('\n').append(am.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    private List<UserType> getSortedUserTypes() {
        ArrayList<UserType> unsortedTypes = new ArrayList<UserType>(this.userTypes.values());
        DirectedGraph<UserType> graph = new DirectedGraph<UserType>(typeByName, (List<UserType>)unsortedTypes);
        for (UserType from : unsortedTypes) {
            for (UserType to : unsortedTypes) {
                if (from == to || !this.dependsOn(to, from)) continue;
                graph.addEdge(from, to);
            }
        }
        return graph.topologicalSort();
    }

    private boolean dependsOn(UserType udt1, UserType udt2) {
        for (UserType.Field field : udt1) {
            if (!this.references(field.getType(), udt2)) continue;
            return true;
        }
        return false;
    }

    private boolean references(DataType dataType, DataType udtType) {
        if (dataType.equals(udtType)) {
            return true;
        }
        for (DataType arg : dataType.getTypeArguments()) {
            if (!this.references(arg, udtType)) continue;
            return true;
        }
        if (dataType instanceof TupleType) {
            for (DataType arg : ((TupleType)dataType).getComponentTypes()) {
                if (!this.references(arg, udtType)) continue;
                return true;
            }
        }
        return false;
    }

    public String asCQLQuery() {
        StringBuilder sb = new StringBuilder();
        if (this.virtual) {
            sb.append("/* VIRTUAL ");
        } else {
            sb.append("CREATE ");
        }
        sb.append("KEYSPACE ").append(Metadata.quoteIfNecessary(this.name)).append(" WITH ");
        sb.append("REPLICATION = { 'class' : '").append(this.replication.get("class")).append('\'');
        for (Map.Entry<String, String> entry : this.replication.entrySet()) {
            if (entry.getKey().equals("class")) continue;
            sb.append(", '").append(entry.getKey()).append("': '").append(entry.getValue()).append('\'');
        }
        sb.append(" } AND DURABLE_WRITES = ").append(this.durableWrites);
        sb.append(';');
        if (this.virtual) {
            sb.append("*/");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.virtual) {
            return this.name;
        }
        return this.asCQLQuery();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyspaceMetadata that = (KeyspaceMetadata)o;
        if (this.durableWrites != that.durableWrites) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (!this.replication.equals(that.replication)) {
            return false;
        }
        return this.tables.equals(that.tables);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.durableWrites ? 1 : 0);
        result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
        result = 31 * result + this.replication.hashCode();
        result = 31 * result + this.tables.hashCode();
        return result;
    }

    void add(TableMetadata tm) {
        this.tables.put(tm.getName(), tm);
    }

    void add(MaterializedViewMetadata view) {
        this.views.put(view.getName(), view);
    }

    void add(FunctionMetadata function) {
        String functionName = Metadata.fullFunctionName(function.getSimpleName(), function.getArguments().values());
        this.functions.put(functionName, function);
    }

    void add(AggregateMetadata aggregate) {
        String aggregateName = Metadata.fullFunctionName(aggregate.getSimpleName(), aggregate.getArgumentTypes());
        this.aggregates.put(aggregateName, aggregate);
    }

    void add(UserType type) {
        this.userTypes.put(type.getTypeName(), type);
    }

    ReplicationStrategy replicationStrategy() {
        return this.strategy;
    }
}

