/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.SystemProperties;
import com.simba.cassandra.shaded.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simba.cassandra.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadingOptions {
    private static final int NON_BLOCKING_EXECUTOR_SIZE = SystemProperties.getInt("com.simba.cassandra.shaded.datastax.driver.NON_BLOCKING_EXECUTOR_SIZE", Runtime.getRuntime().availableProcessors());
    private static final int DEFAULT_THREAD_KEEP_ALIVE_SECONDS = 30;

    public ThreadFactory createThreadFactory(String clusterName, String executorName) {
        return new ThreadFactoryBuilder().setNameFormat(clusterName + "-" + executorName + "-%d").setThreadFactory(new DefaultThreadFactory("ignored name")).build();
    }

    public ExecutorService createExecutor(String clusterName) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(NON_BLOCKING_EXECUTOR_SIZE, NON_BLOCKING_EXECUTOR_SIZE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.createThreadFactory(clusterName, "worker"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public ExecutorService createBlockingExecutor(String clusterName) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.createThreadFactory(clusterName, "blocking-task-worker"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public ScheduledExecutorService createReconnectionExecutor(String clusterName) {
        return new ScheduledThreadPoolExecutor(2, this.createThreadFactory(clusterName, "reconnection"));
    }

    public ScheduledExecutorService createScheduledTasksExecutor(String clusterName) {
        return new ScheduledThreadPoolExecutor(1, this.createThreadFactory(clusterName, "scheduled-task-worker"));
    }

    public ScheduledExecutorService createReaperExecutor(String clusterName) {
        return new ScheduledThreadPoolExecutor(1, this.createThreadFactory(clusterName, "connection-reaper"));
    }
}

