/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.io.netty.util.concurrent.FastThreadLocal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class VIntCoding {
    private static final FastThreadLocal<byte[]> encodingBuffer = new FastThreadLocal<byte[]>(){

        @Override
        public byte[] initialValue() {
            return new byte[9];
        }
    };

    VIntCoding() {
    }

    private static long readUnsignedVInt(DataInput input) throws IOException {
        byte firstByte = input.readByte();
        if (firstByte >= 0) {
            return firstByte;
        }
        int size = VIntCoding.numberOfExtraBytesToRead(firstByte);
        long retval = firstByte & VIntCoding.firstByteValueMask(size);
        for (int ii = 0; ii < size; ++ii) {
            byte b = input.readByte();
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    static long readVInt(DataInput input) throws IOException {
        return VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input));
    }

    private static int firstByteValueMask(int extraBytesToRead) {
        return 255 >> extraBytesToRead;
    }

    private static int encodeExtraBytesToRead(int extraBytesToRead) {
        return ~VIntCoding.firstByteValueMask(extraBytesToRead);
    }

    private static int numberOfExtraBytesToRead(int firstByte) {
        return Integer.numberOfLeadingZeros(~firstByte) - 24;
    }

    private static void writeUnsignedVInt(long value, DataOutput output) throws IOException {
        int size = VIntCoding.computeUnsignedVIntSize(value);
        if (size == 1) {
            output.write((int)value);
            return;
        }
        output.write(VIntCoding.encodeVInt(value, size), 0, size);
    }

    private static byte[] encodeVInt(long value, int size) {
        int extraBytes;
        byte[] encodingSpace = encodingBuffer.get();
        for (int i = extraBytes = size - 1; i >= 0; --i) {
            encodingSpace[i] = (byte)value;
            value >>= 8;
        }
        encodingSpace[0] = (byte)(encodingSpace[0] | VIntCoding.encodeExtraBytesToRead(extraBytes));
        return encodingSpace;
    }

    static void writeVInt(long value, DataOutput output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value), output);
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    static int computeVIntSize(long param) {
        return VIntCoding.computeUnsignedVIntSize(VIntCoding.encodeZigZag64(param));
    }

    private static int computeUnsignedVIntSize(long value) {
        int magnitude = Long.numberOfLeadingZeros(value | 1L);
        return 639 - magnitude * 9 >> 6;
    }
}

