/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.exceptions;

import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.CoordinatorException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class BusyPoolException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public BusyPoolException(EndPoint endPoint, int queueSize) {
        this(endPoint, BusyPoolException.buildMessage(endPoint, queueSize), null);
    }

    public BusyPoolException(EndPoint endPoint, long timeout, TimeUnit unit) {
        this(endPoint, BusyPoolException.buildMessage(endPoint, timeout, unit), null);
    }

    private BusyPoolException(EndPoint endPoint, String message, Throwable cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    private static String buildMessage(EndPoint endPoint, int queueSize) {
        return String.format("[%s] Pool is busy (no available connection and the queue has reached its max size %d)", endPoint, queueSize);
    }

    private static String buildMessage(EndPoint endPoint, long timeout, TimeUnit unit) {
        return String.format("[%s] Pool is busy (no available connection and timed out after %d %s)", new Object[]{endPoint, timeout, unit});
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public BusyPoolException copy() {
        return new BusyPoolException(this.endPoint, this.getMessage(), this);
    }
}

