/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.exceptions;

import com.simba.cassandra.shaded.datastax.driver.core.ConsistencyLevel;
import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.QueryConsistencyException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;

public class ReadFailureException
extends QueryConsistencyException {
    private final int failed;
    private final boolean dataPresent;
    private final Map<InetAddress, Integer> failuresMap;

    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        this(null, consistency, received, required, failed, failuresMap, dataPresent);
    }

    @Deprecated
    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        this(null, consistency, received, required, failed, Collections.emptyMap(), dataPresent);
    }

    public ReadFailureException(EndPoint endPoint, ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        super(endPoint, String.format("Cassandra failure during read query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.failed = failed;
        this.failuresMap = failuresMap;
        this.dataPresent = dataPresent;
    }

    @Deprecated
    public ReadFailureException(EndPoint endPoint, ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        this(endPoint, consistency, received, required, failed, Collections.emptyMap(), dataPresent);
    }

    private ReadFailureException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, int failed, Map<InetAddress, Integer> failuresMap, boolean dataPresent) {
        super(endPoint, msg, cause, consistency, received, required);
        this.failed = failed;
        this.failuresMap = failuresMap;
        this.dataPresent = dataPresent;
    }

    public int getFailures() {
        return this.failed;
    }

    public Map<InetAddress, Integer> getFailuresMap() {
        return this.failuresMap;
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public ReadFailureException copy() {
        return new ReadFailureException(this.getEndPoint(), this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.getFailuresMap(), this.wasDataRetrieved());
    }

    public ReadFailureException copy(EndPoint endPoint) {
        return new ReadFailureException(endPoint, this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed, this.getFailuresMap(), this.dataPresent);
    }
}

