/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.exceptions;

import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.CoordinatorException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverInternalError;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ServerError
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public ServerError(EndPoint endPoint, String message) {
        super(String.format("An unexpected error occurred server side on %s: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    private ServerError(EndPoint endPoint, String message, ServerError cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public ServerError copy() {
        return new ServerError(this.endPoint, this.getMessage(), this);
    }
}

