/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.policies;

import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.ConsistencyLevel;
import com.simba.cassandra.shaded.datastax.driver.core.Statement;
import com.simba.cassandra.shaded.datastax.driver.core.WriteType;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.ReadFailureException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.WriteFailureException;
import com.simba.cassandra.shaded.datastax.driver.core.policies.RetryPolicy;

@Deprecated
public class DowngradingConsistencyRetryPolicy
implements RetryPolicy {
    public static final DowngradingConsistencyRetryPolicy INSTANCE = new DowngradingConsistencyRetryPolicy();

    private DowngradingConsistencyRetryPolicy() {
    }

    private RetryPolicy.RetryDecision maxLikelyToWorkCL(int knownOk, ConsistencyLevel currentCL) {
        if (knownOk >= 3) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.THREE);
        }
        if (knownOk == 2) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.TWO);
        }
        if (knownOk == 1 || currentCL == ConsistencyLevel.EACH_QUORUM) {
            return RetryPolicy.RetryDecision.retry(ConsistencyLevel.ONE);
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (cl.isSerial()) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (receivedResponses < requiredResponses) {
            return this.maxLikelyToWorkCL(receivedResponses, cl);
        }
        return !dataRetrieved ? RetryPolicy.RetryDecision.retry(cl) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        switch (writeType) {
            case SIMPLE: 
            case BATCH: {
                return receivedAcks > 0 ? RetryPolicy.RetryDecision.ignore() : RetryPolicy.RetryDecision.rethrow();
            }
            case UNLOGGED_BATCH: {
                return this.maxLikelyToWorkCL(receivedAcks, cl);
            }
            case BATCH_LOG: {
                return RetryPolicy.RetryDecision.retry(cl);
            }
        }
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        if (nbRetry != 0) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        if (cl.isSerial()) {
            return RetryPolicy.RetryDecision.tryNextHost(null);
        }
        return this.maxLikelyToWorkCL(aliveReplica, cl);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
        if (e instanceof WriteFailureException || e instanceof ReadFailureException) {
            return RetryPolicy.RetryDecision.rethrow();
        }
        return RetryPolicy.RetryDecision.tryNextHost(cl);
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }
}

