/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.querybuilder;

import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Assignment;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.BuiltStatement;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Clause;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Using;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Update
extends BuiltStatement {
    private final String table;
    private final Assignments assignments;
    private final Where where;
    private final Options usings;
    private final Conditions conditions;
    private boolean ifExists;

    Update(String keyspace, String table) {
        this(keyspace, table, null, null);
    }

    Update(TableMetadata table) {
        this(Metadata.quoteIfNecessary(table.getKeyspace().getName()), Metadata.quoteIfNecessary(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey());
    }

    Update(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
        this.assignments = new Assignments(this);
        this.where = new Where(this);
        this.usings = new Options(this);
        this.conditions = new Conditions(this);
        this.ifExists = false;
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.usings.usings, variables);
        }
        if (!this.assignments.assignments.isEmpty()) {
            builder.append(" SET ");
            Utils.joinAndAppend(builder, codecRegistry, ",", this.assignments.assignments, variables);
        }
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.where.clauses, variables);
        }
        if (!this.conditions.conditions.isEmpty()) {
            builder.append(" IF ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.conditions.conditions, variables);
        }
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
        return builder;
    }

    public Assignments with(Assignment assignment) {
        return this.assignments.and(assignment);
    }

    public Assignments with() {
        return this.assignments;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Conditions onlyIf(Clause condition) {
        return this.conditions.and(condition);
    }

    public Conditions onlyIf() {
        return this.conditions;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public static class IfExists
    extends BuiltStatement.ForwardingStatement<Update> {
        IfExists(Update statement) {
            super(statement);
        }
    }

    public static class Conditions
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Clause> conditions = new ArrayList<Clause>();

        Conditions(Update statement) {
            super(statement);
        }

        public Conditions and(Clause condition) {
            ((Update)this.statement).setNonIdempotentOps();
            this.conditions.add(condition);
            this.checkForBindMarkers(condition);
            return this;
        }

        public Assignments with(Assignment assignment) {
            return ((Update)this.statement).with(assignment);
        }

        public Where where(Clause clause) {
            return ((Update)this.statement).where(clause);
        }

        public Options using(Using using) {
            return ((Update)this.statement).using(using);
        }
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Update statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Assignments with(Assignment assignment) {
            return ((Update)this.statement).with(assignment);
        }

        public Where where(Clause clause) {
            return ((Update)this.statement).where(clause);
        }

        public Conditions onlyIf(Clause condition) {
            return ((Update)this.statement).onlyIf(condition);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Update statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Update)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            if (!this.hasNonIdempotentOps() && !Utils.isIdempotent(clause)) {
                ((Update)this.statement).setNonIdempotentOps();
            }
            this.checkForBindMarkers(clause);
            return this;
        }

        public Assignments with(Assignment assignment) {
            return ((Update)this.statement).with(assignment);
        }

        public Options using(Using using) {
            return ((Update)this.statement).using(using);
        }

        public Conditions onlyIf(Clause condition) {
            return ((Update)this.statement).onlyIf(condition);
        }

        public IfExists ifExists() {
            ((Update)this.statement).ifExists = true;
            ((Update)this.statement).setNonIdempotentOps();
            return new IfExists((Update)this.statement);
        }
    }

    public static class Assignments
    extends BuiltStatement.ForwardingStatement<Update> {
        private final List<Assignment> assignments = new ArrayList<Assignment>();

        Assignments(Update statement) {
            super(statement);
        }

        public Assignments and(Assignment assignment) {
            ((Update)this.statement).setCounterOp(assignment instanceof Assignment.CounterAssignment);
            if (!this.hasNonIdempotentOps() && !Utils.isIdempotent(assignment)) {
                ((Update)this.statement).setNonIdempotentOps();
            }
            this.assignments.add(assignment);
            this.checkForBindMarkers(assignment);
            return this;
        }

        public Where where(Clause clause) {
            return ((Update)this.statement).where(clause);
        }

        public Options using(Using using) {
            return ((Update)this.statement).using(using);
        }

        public Conditions onlyIf(Clause condition) {
            return ((Update)this.statement).onlyIf(condition);
        }
    }
}

