/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.schemabuilder;

import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.schemabuilder.SchemaStatement;
import com.simba.cassandra.shaded.datastax.driver.core.schemabuilder.StatementStart;
import com.simba.cassandra.shaded.datastax.driver.core.schemabuilder.TableOptions;
import com.simba.cassandra.shaded.datastax.driver.core.schemabuilder.UDTType;
import com.simba.cassandra.shaded.google.common.base.Optional;
import java.util.List;

public class Alter
implements StatementStart {
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;

    Alter(String keyspaceName, String tableName) {
        SchemaStatement.validateNotEmpty(keyspaceName, "Keyspace name");
        SchemaStatement.validateNotEmpty(tableName, "Table name");
        SchemaStatement.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        SchemaStatement.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        this.keyspaceName = Optional.fromNullable(keyspaceName);
    }

    Alter(String tableName) {
        SchemaStatement.validateNotEmpty(tableName, "Table name");
        SchemaStatement.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
    }

    public AlterColumn alterColumn(String columnName) {
        SchemaStatement.validateNotEmpty(columnName, "Column to be altered");
        SchemaStatement.validateNotKeyWord(columnName, String.format("The altered column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AlterColumn(this, columnName);
    }

    public AddColumn addColumn(String columnName) {
        SchemaStatement.validateNotEmpty(columnName, "Added column");
        SchemaStatement.validateNotKeyWord(columnName, String.format("The new column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AddColumn(this, columnName, false);
    }

    public AddColumn addStaticColumn(String columnName) {
        SchemaStatement.validateNotEmpty(columnName, "Added static column");
        SchemaStatement.validateNotKeyWord(columnName, String.format("The new static column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new AddColumn(this, columnName, true);
    }

    public SchemaStatement dropColumn(String columnName) {
        SchemaStatement.validateNotEmpty(columnName, "Column to be dropped");
        SchemaStatement.validateNotKeyWord(columnName, String.format("The dropped column name '%s' is not allowed because it is a reserved keyword", columnName));
        return SchemaStatement.fromQueryString(this.buildInternal() + " DROP " + columnName);
    }

    public RenameColumn renameColumn(String columnName) {
        SchemaStatement.validateNotEmpty(columnName, "Column to be renamed");
        SchemaStatement.validateNotKeyWord(columnName, String.format("The renamed column name '%s' is not allowed because it is a reserved keyword", columnName));
        return new RenameColumn(this, columnName);
    }

    public Options withOptions() {
        return new Options(this);
    }

    @Override
    public String buildInternal() {
        String tableSpec = this.keyspaceName.isPresent() ? this.keyspaceName.get() + "." + this.tableName : this.tableName;
        return "\n\tALTER TABLE " + tableSpec;
    }

    public static class Options
    extends TableOptions<Options> {
        Options(Alter alter) {
            super(alter);
        }

        @Override
        protected void addSpecificOptions(List<String> options) {
        }
    }

    public static class RenameColumn {
        private final Alter alter;
        private final String columnName;

        RenameColumn(Alter alter, String columnName) {
            this.alter = alter;
            this.columnName = columnName;
        }

        public SchemaStatement to(String newColumnName) {
            SchemaStatement.validateNotEmpty(newColumnName, "New column name");
            SchemaStatement.validateNotKeyWord(newColumnName, String.format("The new column name '%s' is not allowed because it is a reserved keyword", newColumnName));
            return SchemaStatement.fromQueryString(this.alter.buildInternal() + " RENAME " + this.columnName + " TO " + newColumnName);
        }
    }

    public static class AddColumn {
        private final Alter alter;
        private final String columnName;
        private final boolean staticColumn;

        AddColumn(Alter alter, String columnName, boolean staticColumn) {
            this.alter = alter;
            this.columnName = columnName;
            this.staticColumn = staticColumn;
        }

        public SchemaStatement type(DataType type) {
            return SchemaStatement.fromQueryString(this.alter.buildInternal() + " ADD " + this.columnName + " " + type.toString() + (this.staticColumn ? " static" : ""));
        }

        public SchemaStatement udtType(UDTType udtType) {
            return SchemaStatement.fromQueryString(this.alter.buildInternal() + " ADD " + this.columnName + " " + udtType.asCQLString() + (this.staticColumn ? " static" : ""));
        }
    }

    public static class AlterColumn {
        private final Alter alter;
        private final String columnName;

        AlterColumn(Alter alter, String columnName) {
            this.alter = alter;
            this.columnName = columnName;
        }

        public SchemaStatement type(DataType type) {
            return SchemaStatement.fromQueryString(this.alter.buildInternal() + " ALTER " + this.columnName + " TYPE " + type.toString());
        }

        public SchemaStatement udtType(UDTType udtType) {
            return SchemaStatement.fromQueryString(this.alter.buildInternal() + " ALTER " + this.columnName + " TYPE " + udtType.asCQLString());
        }
    }
}

