/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.extras.codecs.enums;

import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;

public class EnumOrdinalCodec<E extends Enum<E>>
extends TypeCodec<E> {
    private final E[] enumConstants;
    private final TypeCodec<Integer> innerCodec;

    public EnumOrdinalCodec(Class<E> enumClass) {
        this(TypeCodec.cint(), enumClass);
    }

    public EnumOrdinalCodec(TypeCodec<Integer> innerCodec, Class<E> enumClass) {
        super(innerCodec.getCqlType(), enumClass);
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
        this.innerCodec = innerCodec;
    }

    @Override
    public ByteBuffer serialize(E value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return this.innerCodec.serialize(value == null ? null : Integer.valueOf(((Enum)value).ordinal()), protocolVersion);
    }

    @Override
    public E deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        Integer ordinal = this.innerCodec.deserialize(bytes, protocolVersion);
        if (ordinal == null) {
            return null;
        }
        return this.enumConstants[ordinal];
    }

    @Override
    public E parse(String value) throws InvalidTypeException {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : (E)this.enumConstants[Integer.parseInt(value)];
    }

    @Override
    public String format(E value) throws InvalidTypeException {
        if (value == null) {
            return "NULL";
        }
        return Integer.toString(((Enum)value).ordinal());
    }
}

