/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.extras.codecs.jdk8;

import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.IgnoreJDK6Requirement;
import com.simba.cassandra.shaded.datastax.driver.core.ParseUtils;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

@IgnoreJDK6Requirement
public class LocalDateTimeCodec
extends TypeCodec<LocalDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    public static final LocalDateTimeCodec instance = new LocalDateTimeCodec();

    private LocalDateTimeCodec() {
        super(DataType.timestamp(), LocalDateTime.class);
    }

    @Override
    public ByteBuffer serialize(LocalDateTime value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        long millis = value.atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        return LocalDateTimeCodec.bigint().serializeNoBoxing(millis, protocolVersion);
    }

    @Override
    public LocalDateTime deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        long millis = LocalDateTimeCodec.bigint().deserializeNoBoxing(bytes, protocolVersion);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    @Override
    public String format(LocalDateTime value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(FORMATTER.format(value));
    }

    @Override
    public LocalDateTime parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            try {
                long millis = Long.parseLong(value);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
            }
        }
        try {
            return LocalDateTime.from(FORMATTER.parse(value));
        }
        catch (DateTimeParseException e) {
            throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value));
        }
    }
}

