/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.extras.codecs.jdk8;

import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.IgnoreJDK6Requirement;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.ZoneId;

@IgnoreJDK6Requirement
public class ZoneIdCodec
extends TypeCodec<ZoneId> {
    public static final ZoneIdCodec instance = new ZoneIdCodec();

    private ZoneIdCodec() {
        super(DataType.varchar(), ZoneId.class);
    }

    @Override
    public ByteBuffer serialize(ZoneId value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ZoneIdCodec.varchar().serialize(value.toString(), protocolVersion);
    }

    @Override
    public ZoneId deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        return ZoneId.of(ZoneIdCodec.varchar().deserialize(bytes, protocolVersion));
    }

    @Override
    public String format(ZoneId value) {
        if (value == null) {
            return "NULL";
        }
        return ZoneIdCodec.varchar().format(value.toString());
    }

    @Override
    public ZoneId parse(String value) {
        String parsed = ZoneIdCodec.varchar().parse(value);
        if (parsed == null || parsed.isEmpty() || parsed.equalsIgnoreCase("NULL")) {
            return null;
        }
        try {
            return ZoneId.of(parsed);
        }
        catch (DateTimeException e) {
            String msg = String.format("Cannot parse zone-ID value from \"%s\"", value);
            throw new InvalidTypeException(msg);
        }
    }
}

