/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.extras.codecs.joda;

import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.ParseUtils;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.TupleType;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.InvalidTypeException;
import com.simba.cassandra.shaded.google.common.base.Preconditions;
import com.simba.cassandra.shaded.joda.time.DateTime;
import com.simba.cassandra.shaded.joda.time.DateTimeZone;
import com.simba.cassandra.shaded.joda.time.format.DateTimeFormatter;
import com.simba.cassandra.shaded.joda.time.format.ISODateTimeFormat;
import java.nio.ByteBuffer;
import java.util.List;

public class DateTimeCodec
extends TypeCodec.AbstractTupleCodec<DateTime> {
    private static final DateTimeFormatter DEFAULT_PARSER = ISODateTimeFormat.dateOptionalTimeParser();
    private static final DateTimeFormatter DEFFAULT_PRINTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private final DateTimeFormatter parser;
    private final DateTimeFormatter printer;

    public DateTimeCodec(TupleType tupleType) {
        this(tupleType, DEFAULT_PARSER, DEFFAULT_PRINTER);
    }

    public DateTimeCodec(TupleType tupleType, DateTimeFormatter parser, DateTimeFormatter printer) {
        super(tupleType, DateTime.class);
        this.parser = parser;
        this.printer = printer;
        List<DataType> types = tupleType.getComponentTypes();
        Preconditions.checkArgument(types.size() == 2 && types.get(0).equals(DataType.timestamp()) && types.get(1).equals(DataType.varchar()), "Expected tuple<timestamp,varchar>, got %s", tupleType);
    }

    @Override
    protected DateTime newInstance() {
        return null;
    }

    @Override
    protected ByteBuffer serializeField(DateTime source, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = source.getMillis();
            return DateTimeCodec.bigint().serializeNoBoxing(millis, protocolVersion);
        }
        if (index == 1) {
            return DateTimeCodec.varchar().serialize(source.getZone().getID(), protocolVersion);
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected DateTime deserializeAndSetField(ByteBuffer input, DateTime target, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = DateTimeCodec.bigint().deserializeNoBoxing(input, protocolVersion);
            return new DateTime(millis);
        }
        if (index == 1) {
            String zoneId = DateTimeCodec.varchar().deserialize(input, protocolVersion);
            return target.withZone(DateTimeZone.forID(zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected String formatField(DateTime value, int index) {
        if (index == 0) {
            return ParseUtils.quote(this.printer.print(value));
        }
        if (index == 1) {
            return ParseUtils.quote(value.getZone().getID());
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected DateTime parseAndSetField(String input, DateTime target, int index) {
        if (index == 0) {
            if (ParseUtils.isQuoted(input)) {
                input = ParseUtils.unquote(input);
            }
            if (ParseUtils.isLongLiteral(input)) {
                try {
                    long millis = Long.parseLong(input);
                    return new DateTime(millis);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", input));
                }
            }
            try {
                return this.parser.parseDateTime(input);
            }
            catch (RuntimeException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", target));
            }
        }
        if (index == 1) {
            String zoneId = DateTimeCodec.varchar().parse(input);
            if ("Z".equals(zoneId)) {
                return target.withZone(DateTimeZone.UTC);
            }
            return target.withZone(DateTimeZone.forID(zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }
}

