/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.extras.codecs.json;

import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.ParseUtils;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.InvalidTypeException;
import com.simba.cassandra.shaded.datastax.driver.core.utils.Bytes;
import com.simba.cassandra.shaded.javax.json.Json;
import com.simba.cassandra.shaded.javax.json.JsonException;
import com.simba.cassandra.shaded.javax.json.JsonReader;
import com.simba.cassandra.shaded.javax.json.JsonReaderFactory;
import com.simba.cassandra.shaded.javax.json.JsonStructure;
import com.simba.cassandra.shaded.javax.json.JsonWriter;
import com.simba.cassandra.shaded.javax.json.JsonWriterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;

public class Jsr353JsonCodec
extends TypeCodec<JsonStructure> {
    private final JsonReaderFactory readerFactory;
    private final JsonWriterFactory writerFactory;

    public Jsr353JsonCodec() {
        this(null);
    }

    public Jsr353JsonCodec(Map<String, ?> config) {
        super(DataType.varchar(), JsonStructure.class);
        this.readerFactory = Json.createReaderFactory(config);
        this.writerFactory = Json.createWriterFactory(config);
    }

    @Override
    public ByteBuffer serialize(JsonStructure value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonWriter writer = this.writerFactory.createWriter(baos);
            writer.write(value);
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public JsonStructure deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Bytes.getArray(bytes));
        try {
            JsonReader reader = this.readerFactory.createReader(bais);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String format(JsonStructure value) throws InvalidTypeException {
        String json;
        if (value == null) {
            return "NULL";
        }
        StringWriter sw = new StringWriter();
        try {
            JsonWriter writer = this.writerFactory.createWriter(sw);
            writer.write(value);
            json = sw.toString();
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), e);
            }
        }
        return ParseUtils.quote(json);
    }

    @Override
    public JsonStructure parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted(value)) {
            throw new InvalidTypeException("JSON strings must be enclosed by single quotes");
        }
        String json = ParseUtils.unquote(value);
        StringReader sr = new StringReader(json);
        try {
            JsonReader reader = this.readerFactory.createReader(sr);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
        finally {
            sr.close();
        }
    }
}

