/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.mapping;

import com.simba.cassandra.shaded.datastax.driver.mapping.AccessorMapper;
import com.simba.cassandra.shaded.datastax.driver.mapping.MethodMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class AccessorInvocationHandler<T>
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Method TO_STRING;
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private final AccessorMapper<T> mapper;
    private final Map<Method, MethodMapper> methodMap = new HashMap<Method, MethodMapper>();

    AccessorInvocationHandler(AccessorMapper<T> mapper) {
        this.mapper = mapper;
        for (MethodMapper method : mapper.methods) {
            this.methodMap.put(method.method, method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(TO_STRING)) {
            return this.mapper.daoClass.getSimpleName() + " implementation generated by the Cassandra driver mapper";
        }
        if (m.equals(EQUALS)) {
            return proxy == args[0];
        }
        if (m.equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        MethodMapper method = this.methodMap.get(m);
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        return method.invoke(args == null ? NO_ARGS : args);
    }

    static {
        try {
            TO_STRING = Object.class.getMethod("toString", new Class[0]);
            EQUALS = Object.class.getMethod("equals", Object.class);
            HASH_CODE = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

