/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.mapping;

import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.mapping.MappedProperty;
import com.simba.cassandra.shaded.datastax.driver.mapping.ReflectionUtils;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.ClusteringColumn;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.Column;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.Computed;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.Defaults;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.Field;
import com.simba.cassandra.shaded.datastax.driver.mapping.annotations.PartitionKey;
import com.simba.cassandra.shaded.google.common.base.Preconditions;
import com.simba.cassandra.shaded.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

class DefaultMappedProperty<T>
implements MappedProperty<T> {
    private final Class<?> mappedClass;
    private final String propertyName;
    private final TypeToken<T> propertyType;
    private final String mappedName;
    private final boolean partitionKey;
    private final boolean clusteringColumn;
    private final boolean computed;
    private final int position;
    private final TypeCodec<T> customCodec;
    private final java.lang.reflect.Field field;
    private final Method getter;
    private final Method setter;

    static <T> DefaultMappedProperty<T> create(Class<?> mappedClass, String propertyName, String mappedName, java.lang.reflect.Field field, Method getter, Method setter, Map<Class<? extends Annotation>, Annotation> annotations) {
        TypeToken<?> propertyType = DefaultMappedProperty.inferType(field, getter);
        boolean partitionKey = annotations.containsKey(PartitionKey.class);
        boolean clusteringColumn = annotations.containsKey(ClusteringColumn.class);
        boolean computed = annotations.containsKey(Computed.class);
        int position = DefaultMappedProperty.inferPosition(annotations);
        Class<TypeCodec<?>> codecClass = DefaultMappedProperty.getCustomCodecClass(annotations);
        return new DefaultMappedProperty(mappedClass, propertyName, mappedName, propertyType, partitionKey, clusteringColumn, computed, position, codecClass, field, getter, setter);
    }

    private DefaultMappedProperty(Class<?> mappedClass, String propertyName, String mappedName, TypeToken<T> propertyType, boolean partitionKey, boolean clusteringColumn, boolean computed, int position, Class<? extends TypeCodec<T>> codecClass, java.lang.reflect.Field field, Method getter, Method setter) {
        Preconditions.checkArgument(propertyName != null && !propertyName.isEmpty());
        Preconditions.checkArgument(mappedName != null && !mappedName.isEmpty());
        Preconditions.checkNotNull(propertyType);
        this.mappedClass = mappedClass;
        this.propertyName = propertyName;
        this.mappedName = mappedName;
        this.propertyType = propertyType;
        this.partitionKey = partitionKey;
        this.clusteringColumn = clusteringColumn;
        this.computed = computed;
        this.position = position;
        this.customCodec = codecClass == null || codecClass.equals(Defaults.NoCodec.class) ? null : ReflectionUtils.newInstance(codecClass);
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public TypeToken<T> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public TypeCodec<T> getCustomCodec() {
        return this.customCodec;
    }

    @Override
    public boolean isComputed() {
        return this.computed;
    }

    @Override
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public boolean isClusteringColumn() {
        return this.clusteringColumn;
    }

    @Override
    public T getValue(Object entity) {
        try {
            if (this.getter != null && this.getter.isAccessible()) {
                return (T)this.getter.invoke(entity, new Object[0]);
            }
            return (T)Preconditions.checkNotNull(this.field).get(entity);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read property '" + this.getPropertyName() + "' in " + entity.getClass(), e);
        }
    }

    @Override
    public void setValue(Object entity, T value) {
        try {
            if (this.setter != null && this.setter.isAccessible()) {
                this.setter.invoke(entity, value);
            } else {
                Preconditions.checkNotNull(this.field).set(entity, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to write property '" + this.getPropertyName() + "' in " + entity.getClass(), e);
        }
    }

    public String toString() {
        return this.mappedClass.getSimpleName() + "." + this.getPropertyName();
    }

    private static TypeToken<?> inferType(java.lang.reflect.Field field, Method getter) {
        if (getter != null) {
            return TypeToken.of(getter.getGenericReturnType());
        }
        return TypeToken.of(Preconditions.checkNotNull(field).getGenericType());
    }

    private static int inferPosition(Map<Class<? extends Annotation>, Annotation> annotations) {
        if (annotations.containsKey(PartitionKey.class)) {
            return ((PartitionKey)annotations.get(PartitionKey.class)).value();
        }
        if (annotations.containsKey(ClusteringColumn.class)) {
            return ((ClusteringColumn)annotations.get(ClusteringColumn.class)).value();
        }
        return -1;
    }

    private static Class<? extends TypeCodec<?>> getCustomCodecClass(Map<Class<? extends Annotation>, Annotation> annotations) {
        Column column = (Column)annotations.get(Column.class);
        if (column != null) {
            return column.codec();
        }
        Field udtField = (Field)annotations.get(Field.class);
        if (udtField != null) {
            return udtField.codec();
        }
        return null;
    }
}

