/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.mapping;

import com.simba.cassandra.shaded.datastax.driver.mapping.NamingConvention;
import com.simba.cassandra.shaded.datastax.driver.mapping.NamingConventions;
import com.simba.cassandra.shaded.datastax.driver.mapping.NamingStrategy;

public class DefaultNamingStrategy
implements NamingStrategy {
    private NamingConvention javaConvention;
    private NamingConvention cassandraConvention;

    public DefaultNamingStrategy() {
        this(NamingConventions.LOWER_CAMEL_CASE, NamingConventions.LOWER_CASE);
    }

    public DefaultNamingStrategy(NamingConvention javaConvention, NamingConvention cassandraConvention) {
        if (javaConvention == null || cassandraConvention == null) {
            throw new IllegalArgumentException("input/output NamingConvention cannot be null");
        }
        this.javaConvention = javaConvention;
        this.cassandraConvention = cassandraConvention;
    }

    @Override
    public String toCassandraName(String javaPropertyName) {
        return this.cassandraConvention.join(this.javaConvention.split(javaPropertyName));
    }
}

