/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.jnr.posix;

import com.simba.cassandra.shaded.jnr.constants.platform.Sysconf;
import com.simba.cassandra.shaded.jnr.ffi.LibraryLoader;
import com.simba.cassandra.shaded.jnr.ffi.Memory;
import com.simba.cassandra.shaded.jnr.ffi.Pointer;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import com.simba.cassandra.shaded.jnr.posix.BaseNativePOSIX;
import com.simba.cassandra.shaded.jnr.posix.FileStat;
import com.simba.cassandra.shaded.jnr.posix.LibCProvider;
import com.simba.cassandra.shaded.jnr.posix.MacOSFileStat;
import com.simba.cassandra.shaded.jnr.posix.MacOSMsgHdr;
import com.simba.cassandra.shaded.jnr.posix.MacOSPasswd;
import com.simba.cassandra.shaded.jnr.posix.MacOSSocketMacros;
import com.simba.cassandra.shaded.jnr.posix.MsgHdr;
import com.simba.cassandra.shaded.jnr.posix.NSGetEnviron;
import com.simba.cassandra.shaded.jnr.posix.NativeTimes;
import com.simba.cassandra.shaded.jnr.posix.POSIXHandler;
import com.simba.cassandra.shaded.jnr.posix.SocketMacros;
import com.simba.cassandra.shaded.jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    private final NSGetEnviron environ;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        this.environ = loader.load();
    }

    @Override
    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return this.environ._NSGetEnviron().getPointer(0L);
    }
}

