/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aebuilder.statement;

import com.simba.cassandra.dsi.core.utilities.Variant;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.Nullable;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.dsi.exceptions.NumericOverflowException;
import com.simba.cassandra.sqlengine.aeprocessor.AEQTableName;
import com.simba.cassandra.sqlengine.aeprocessor.AEUtils;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AECreateTable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IColumnFactory;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ddl.PrimaryKeyConstraint;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ddl.TableConstraint;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ddl.TableSpecification;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ddl.UniqueConstraint;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.parser.parsetree.IPTNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTFlagNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTIdentifierNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTListNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTLiteralNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTNonterminalNode;
import com.simba.cassandra.sqlengine.parser.type.PTFlagType;
import com.simba.cassandra.sqlengine.parser.type.PTListType;
import com.simba.cassandra.sqlengine.parser.type.PTLiteralType;
import com.simba.cassandra.sqlengine.parser.type.PTNonterminalType;
import com.simba.cassandra.sqlengine.parser.type.PTPositionalType;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.DiagState;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class AEDdlStatementBuilder
extends AEBuilderBase<IAEStatement> {
    public AEDdlStatementBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public IAEStatement visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case CREATE_TABLE_STATEMENT: {
                return this.buildCreateTableStmt(pTNonterminalNode);
            }
            case DROP_TABLE_STATEMENT: {
                return this.buildDropTableStmt(pTNonterminalNode);
            }
        }
        return (IAEStatement)super.visit(pTNonterminalNode);
    }

    private AEDropTable buildDropTableStmt(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        long l;
        AEQueryScope aEQueryScope = this.getQueryScope();
        try {
            l = aEQueryScope.getDataEngine().getContext().getConnProperty(52).getLong();
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new RuntimeException(incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new RuntimeException(numericOverflowException);
        }
        if (0L == (l & 1L)) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.DROP_TABLE_NOT_SUPPORTED.name());
        }
        AEUtils.checkReadOnly(aEQueryScope.getDataEngine().getContext(), "DROP TABLE");
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.DROP_TABLE_STATEMENT).withExactChildren(PTPositionalType.TABLE_NAME, AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_NAME))));
        AEQTableName aEQTableName = AEQTableName.fromPTNode((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME));
        if (!aEQueryScope.getDataEngine().doesTableExist(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName())) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_OR_VIEW_NOT_EXISTS.name());
        }
        Variant variant = this.getQueryScope().getDataEngine().getProperty(15);
        String string = variant.getString();
        aEQTableName = string.equalsIgnoreCase("Y") ? AEUtils.adjustCatalogAndSchema(aEQTableName, aEQueryScope.getDataEngine().getContext(), true) : AEUtils.adjustCatalogAndSchema(aEQTableName, aEQueryScope.getDataEngine().getContext(), false);
        boolean bl = aEQueryScope.isCaseSensitive();
        return new AEDropTable(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName(), bl);
    }

    private AECreateTable buildCreateTableStmt(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        long l;
        AEQueryScope aEQueryScope = this.getQueryScope();
        try {
            l = aEQueryScope.getDataEngine().getContext().getConnProperty(34).getLong();
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new RuntimeException(incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new RuntimeException(numericOverflowException);
        }
        if (0L == (l & 1L)) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CREATE_TABLE_NOT_SUPPORTED.name());
        }
        AEUtils.checkReadOnly(aEQueryScope.getDataEngine().getContext(), "CREATE TABLE");
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.CREATE_TABLE_STATEMENT).withExactChildren(PTPositionalType.TABLE_NAME, AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_NAME), PTPositionalType.COLUMN_DEFINITION_LIST, AEBuilderCheck.list(PTListType.COLUMN_DEFINITION_LIST), PTPositionalType.TABLE_CONSTRAINT_DEFINITION_LIST, AEBuilderCheck.optionalList(PTListType.TABLE_CONSTRAINT_DEFINITION_LIST))));
        AEQTableName aEQTableName = AEQTableName.fromPTNode((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.TABLE_NAME));
        if (aEQueryScope.getDataEngine().doesTableExist(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName())) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_OR_VIEW_ALREADY_EXISTS.name());
        }
        Variant variant = this.getQueryScope().getDataEngine().getProperty(15);
        String string = variant.getString();
        aEQTableName = string.equalsIgnoreCase("Y") ? AEUtils.adjustCatalogAndSchema(aEQTableName, aEQueryScope.getDataEngine().getContext(), true) : AEUtils.adjustCatalogAndSchema(aEQTableName, aEQueryScope.getDataEngine().getContext(), false);
        boolean bl = aEQueryScope.isCaseSensitive();
        PTListNode pTListNode = (PTListNode)pTNonterminalNode.getChild(PTPositionalType.COLUMN_DEFINITION_LIST);
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        AbstractSet abstractSet = null;
        abstractSet = bl ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        IColumnFactory iColumnFactory = aEQueryScope.getDataEngine().getContext().getCustomBehaviourProvider().getColumnFactory();
        for (IPTNode object2 : pTListNode.getImmutableChildList()) {
            IColumn iColumn = this.createColumnDefinition(aEQTableName, object2, iColumnFactory);
            if (abstractSet.contains(iColumn.getName())) {
                throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.COLUMN_NAME_DUPLICATED.name(), new String[]{iColumn.getName(), aEQTableName.getTableName()});
            }
            abstractSet.add(iColumn.getName());
            arrayList.add(iColumn);
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.TABLE_CONSTRAINT_DEFINITION_LIST);
        List<TableConstraint> list = this.getTableConstraints(abstractSet, iPTNode, (l & 0x1000L) != 0L);
        return new AECreateTable(new TableSpecification(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName(), arrayList, list), bl);
    }

    private IColumn createColumnDefinition(AEQTableName aEQTableName, IPTNode iPTNode, IColumnFactory iColumnFactory) throws ErrorException {
        AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.COLUMN_DEFINITION).withExactChildren(PTPositionalType.COLUMN_NAME, AEBuilderCheck.identifier(), PTPositionalType.COLUMN_TYPE, AEBuilderCheck.nonTerminal(PTNonterminalType.DATA_TYPE), PTPositionalType.COLUMN_CONSTRAINT, AEBuilderCheck.optional(AEBuilderCheck.nonTerminal(PTNonterminalType.COLUMN_CONSTRAINT_DEFINITION)))));
        PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode;
        PTIdentifierNode pTIdentifierNode = (PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.COLUMN_NAME);
        String string = pTIdentifierNode.getIdentifier();
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.COLUMN_TYPE);
        Pair<String, List<String>> pair = this.getTypeInfo(pTNonterminalNode2);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.COLUMN_CONSTRAINT);
        Nullable nullable = this.getNullable(iPTNode2);
        return iColumnFactory.createColumn(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName(), string, pair.key(), pair.value(), nullable);
    }

    private Pair<String, List<String>> getTypeInfo(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        AEBuilderCheck.checkThat(pTNonterminalNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.DATA_TYPE).withExactChildren(PTPositionalType.DATA_TYPE_IDENTIFIER, AEBuilderCheck.identifier(), PTPositionalType.DATA_TYPE_ATTRIBUTE_LIST, AEBuilderCheck.optionalList(PTListType.DATA_TYPE_ATTRIBUTE_LIST))));
        PTIdentifierNode pTIdentifierNode = (PTIdentifierNode)pTNonterminalNode.getChild(PTPositionalType.DATA_TYPE_IDENTIFIER);
        String string = pTIdentifierNode.getIdentifier();
        List<String> list = this.getTypeParam(pTNonterminalNode.getChild(PTPositionalType.DATA_TYPE_ATTRIBUTE_LIST));
        return new Pair<String, List<String>>(string, list);
    }

    private List<String> getTypeParam(IPTNode iPTNode) throws ErrorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iPTNode.isEmptyNode()) {
            return arrayList;
        }
        PTListNode pTListNode = (PTListNode)iPTNode;
        for (IPTNode iPTNode2 : pTListNode.getImmutableChildList()) {
            if (iPTNode2 instanceof PTIdentifierNode) {
                arrayList.add(((PTIdentifierNode)iPTNode2).getIdentifier());
                continue;
            }
            if (iPTNode2 instanceof PTLiteralNode) {
                PTLiteralNode pTLiteralNode = (PTLiteralNode)iPTNode2;
                if (PTLiteralType.CHARSTR == pTLiteralNode.getLiteralType()) {
                    arrayList.add("'" + pTLiteralNode.getStringValue() + "'");
                    continue;
                }
                arrayList.add(pTLiteralNode.getStringValue());
                continue;
            }
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        return arrayList;
    }

    private Nullable getNullable(IPTNode iPTNode) throws ErrorException {
        if (iPTNode.isEmptyNode()) {
            return Nullable.UNKNOWN;
        }
        if (iPTNode instanceof PTNonterminalNode) {
            AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.is(AEBuilderCheck.nonTerminal().withExactChildren(PTPositionalType.COLUMN_CONSTRAINT_FLAG, AEBuilderCheck.flagNode())));
            PTFlagNode pTFlagNode = (PTFlagNode)((PTNonterminalNode)iPTNode).getChild(PTPositionalType.COLUMN_CONSTRAINT_FLAG);
            if (PTFlagType.NULL == pTFlagNode.getFlagType()) {
                return Nullable.NULLABLE;
            }
            if (PTFlagType.NOT_NULL == pTFlagNode.getFlagType()) {
                return Nullable.NO_NULLS;
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private List<TableConstraint> getTableConstraints(Set<String> set, IPTNode iPTNode, boolean bl) throws ErrorException {
        assert (set != null);
        assert (iPTNode != null);
        ArrayList<TableConstraint> arrayList = new ArrayList<TableConstraint>();
        if (iPTNode.isEmptyNode()) {
            return arrayList;
        }
        if (!bl) {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.TABLE_CONSTRAINTS_NOT_SUPPORTED.name());
        }
        AEBuilderCheck.checkThat(iPTNode, AEBuilderCheck.optionalList(PTListType.TABLE_CONSTRAINT_DEFINITION_LIST));
        PTListNode pTListNode = (PTListNode)iPTNode;
        for (IPTNode iPTNode2 : pTListNode.getImmutableChildList()) {
            AEBuilderCheck.checkThat(iPTNode2, AEBuilderCheck.is(AEBuilderCheck.nonTerminal(PTNonterminalType.TABLE_CONSTRAINT_DEFINITION).withExactChildren(PTPositionalType.UNIQUE_SPECIFICATION, AEBuilderCheck.flagNode(PTFlagType.UNIQUE, PTFlagType.PRIMARY_KEY), PTPositionalType.COLUMN_LIST, AEBuilderCheck.list(PTListType.COLUMN_NAME_LIST))));
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iPTNode2;
            PTFlagType pTFlagType = ((PTFlagNode)pTNonterminalNode.getChild(PTPositionalType.UNIQUE_SPECIFICATION)).getFlagType();
            PTListNode pTListNode2 = (PTListNode)pTNonterminalNode.getChild(PTPositionalType.COLUMN_LIST);
            HashSet<String> hashSet = new HashSet<String>();
            for (IPTNode iPTNode3 : pTListNode2.getImmutableChildList()) {
                if (!(iPTNode3 instanceof PTIdentifierNode)) continue;
                String string = ((PTIdentifierNode)iPTNode3).getIdentifier();
                if (!set.contains(string)) {
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_TABLE_CONSTRAINT_SPECIFICATION.name(), new String[]{"column name " + string + " is not defined"});
                }
                hashSet.add(string);
            }
            if (pTFlagType == PTFlagType.UNIQUE) {
                arrayList.add(new UniqueConstraint(null, hashSet));
                continue;
            }
            arrayList.add(new PrimaryKeyConstraint(null, hashSet));
        }
        return arrayList;
    }
}

