/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aeoptimizer;

import com.simba.cassandra.sqlengine.aeprocessor.aemanipulator.AETreeManipulator;
import com.simba.cassandra.sqlengine.aeprocessor.aeoptimizer.IAEOptimizer;
import com.simba.cassandra.sqlengine.aeprocessor.aeoptimizer.NullRejectVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.simba.cassandra.sqlengine.dsiext.dataengine.PassdownInformation;
import com.simba.cassandra.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AEFilterOptimizer
implements IAEOptimizer {
    private SqlDataEngineContext m_context;
    private PassdownInformation m_passdownInfo;
    private IAENode m_currentRoot;

    public AEFilterOptimizer(SqlDataEngineContext sqlDataEngineContext, PassdownInformation passdownInformation) {
        this.m_context = sqlDataEngineContext;
        this.m_passdownInfo = passdownInformation;
    }

    @Override
    public void optimize(IAEStatement iAEStatement) throws ErrorException {
        if (null == iAEStatement) {
            throw new NullPointerException("statement cannot be null.");
        }
        this.m_currentRoot = iAEStatement;
        this.clearOptimizationFlags(iAEStatement);
        this.convertOuterJoin(iAEStatement);
        this.doOptimize(iAEStatement);
        this.postProcess(iAEStatement);
    }

    private void doOptimize(IAENode iAENode) throws ErrorException {
        assert (null != iAENode);
        final AEDefaultVisitor<Boolean> aEDefaultVisitor = new AEDefaultVisitor<Boolean>(){

            @Override
            public Boolean visit(AEProxyColumn aEProxyColumn) {
                return true;
            }

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    IAENode iAENode2 = iterator.next();
                    if (!iAENode2.acceptVisitor(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
        class OptimizeAction
        extends AETreeWalker.Action<Boolean> {
            private boolean m_optimized = false;

            OptimizeAction() {
            }

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AESubQuery) {
                    this.skipChildren();
                    IAENode iAENode2 = AEFilterOptimizer.this.m_currentRoot;
                    AEFilterOptimizer.this.m_currentRoot = iAENode;
                    AEFilterOptimizer.this.doOptimize(((AESubQuery)iAENode).getOperand());
                    AEFilterOptimizer.this.m_currentRoot = iAENode2;
                    return;
                }
                if (iAENode instanceof AEValueSubQuery) {
                    this.skipChildren();
                    IAENode iAENode3 = AEFilterOptimizer.this.m_currentRoot;
                    AEFilterOptimizer.this.m_currentRoot = iAENode;
                    AEFilterOptimizer.this.doOptimize(((AEValueSubQuery)iAENode).getQueryExpression());
                    AEFilterOptimizer.this.m_currentRoot = iAENode3;
                    return;
                }
                if (!(iAENode instanceof AEBooleanExpr)) {
                    return;
                }
                AEBooleanExpr aEBooleanExpr = (AEBooleanExpr)iAENode;
                if (aEBooleanExpr.isOptimized() || aEBooleanExpr instanceof AEBooleanTrue) {
                    this.skipChildren();
                    return;
                }
                if (!((Boolean)aEBooleanExpr.acceptVisitor(aEDefaultVisitor)).booleanValue()) {
                    if (AEFilterOptimizer.this.pushDownFilter(aEBooleanExpr, false)) {
                        this.m_optimized = true;
                        this.skipAll();
                    }
                } else {
                    AEFilterOptimizer.this.setFilterOptimized(aEBooleanExpr);
                }
            }

            @Override
            public Boolean getResult() {
                return this.m_optimized;
            }
        }
        while (AETreeWalker.walk(iAENode, new OptimizeAction()).booleanValue()) {
        }
    }

    private boolean doPushDownFilter(AEBooleanExpr aEBooleanExpr, boolean bl) throws ErrorException {
        assert (null != aEBooleanExpr);
        assert (null != this.m_currentRoot);
        Set<String> set = this.extractRelationalExprs(aEBooleanExpr);
        if (0 == set.size()) {
            this.setFilterOptimized(aEBooleanExpr);
            return false;
        }
        IAENode iAENode = aEBooleanExpr.getParent();
        if (!(iAENode instanceof AERelationalExpr)) {
            while (!(iAENode instanceof AERelationalExpr) && iAENode != this.m_currentRoot) {
                iAENode = iAENode.getParent();
            }
        }
        AETreeWalker aETreeWalker = new AETreeWalker(iAENode);
        AERelationalExpr aERelationalExpr = null;
        while (aETreeWalker.hasNext()) {
            IAENode iAENode2 = aETreeWalker.next();
            if (!(iAENode2 instanceof AEJoin) && !(iAENode2 instanceof AECrossJoin)) continue;
            AEBinaryRelationalExpr aEBinaryRelationalExpr = (AEBinaryRelationalExpr)iAENode2;
            PushdownInfo pushdownInfo = new PushdownInfo(aEBinaryRelationalExpr, new HashSet<String>(set), bl);
            boolean bl2 = this.processJoin(pushdownInfo);
            if (!bl2) break;
            if (pushdownInfo.m_isInLeftSubTree) {
                aERelationalExpr = pushdownInfo.m_joinNode.getLeftOperand();
                pushdownInfo.m_inOuterJoinCond = false;
                aETreeWalker = new AETreeWalker(aEBinaryRelationalExpr.getLeftOperand());
                continue;
            }
            if (!pushdownInfo.m_foundRelExprInLeft) {
                aERelationalExpr = pushdownInfo.m_joinNode.getRightOperand();
                pushdownInfo.m_inOuterJoinCond = false;
                aETreeWalker = new AETreeWalker(aEBinaryRelationalExpr.getRightOperand());
                continue;
            }
            if (!(pushdownInfo.m_joinNode instanceof AECrossJoin) && ((AEJoin)pushdownInfo.m_joinNode).isOuterJoin()) continue;
            aERelationalExpr = pushdownInfo.m_joinNode;
        }
        boolean bl3 = false;
        if (null != aERelationalExpr) {
            AETreeManipulator.pushDownFilter(this.m_passdownInfo, aEBooleanExpr, aERelationalExpr);
            bl3 = true;
        } else {
            aEBooleanExpr.setIsOptimized(true);
        }
        return bl3;
    }

    private boolean pushDownFilter(AEBooleanExpr aEBooleanExpr, boolean bl) throws ErrorException {
        IAENode iAENode;
        assert (null != aEBooleanExpr);
        if (aEBooleanExpr.isOptimized()) {
            return false;
        }
        if (this.childOfSearchedWhenClause(aEBooleanExpr)) {
            this.setFilterOptimized(aEBooleanExpr);
            return false;
        }
        IAENode iAENode2 = aEBooleanExpr.getParent();
        boolean bl2 = bl;
        if (!bl2 && iAENode2 instanceof AEJoin && ((AEJoin)(iAENode = (AEJoin)iAENode2)).isOuterJoin()) {
            bl2 = true;
        }
        switch (aEBooleanExpr.getType()) {
            case COMPARISON: 
            case LIKE_PRED: 
            case NULL_PRED: 
            case NOT: {
                return this.doPushDownFilter(aEBooleanExpr, bl2);
            }
            case OR: {
                return this.pushDownOr((AEOr)aEBooleanExpr, bl2);
            }
            case AND: {
                return this.pushDownAnd((AEAnd)aEBooleanExpr, bl2);
            }
            case IN_PRED: {
                iAENode = (AEInPredicate)aEBooleanExpr;
                IAENode iAENode3 = ((AEInPredicate)iAENode).getRightOperand().getChildItr().next();
                if (iAENode3 instanceof AESubQuery || iAENode3 instanceof AEValueSubQuery) {
                    this.setFilterOptimized((AEBooleanExpr)iAENode);
                    this.doOptimize(iAENode3);
                    return true;
                }
                return this.doPushDownFilter((AEBooleanExpr)iAENode, bl);
            }
            case EXISTS_PRED: {
                iAENode = (AEExistsPredicate)aEBooleanExpr;
                this.setFilterOptimized((AEBooleanExpr)iAENode);
                this.doOptimize(((AEExistsPredicate)iAENode).getOperand());
                return true;
            }
            case QUANITIFIED_COMPARISON: {
                iAENode = (AEQuantifiedComparison)aEBooleanExpr;
                this.setFilterOptimized((AEBooleanExpr)iAENode);
                this.doOptimize(((AEQuantifiedComparison)iAENode).getRightOperand());
                return true;
            }
        }
        aEBooleanExpr.setIsOptimized(true);
        return false;
    }

    private boolean pushDownAnd(AEAnd aEAnd, boolean bl) throws ErrorException {
        assert (null != aEAnd);
        AEBooleanExpr aEBooleanExpr = aEAnd.getLeftOperand();
        AEBooleanExpr aEBooleanExpr2 = aEAnd.getRightOperand();
        if (aEBooleanExpr.isOptimized() && aEBooleanExpr2.isOptimized()) {
            aEAnd.setIsOptimized(true);
            return false;
        }
        boolean bl2 = false;
        if (!aEBooleanExpr.isOptimized()) {
            bl2 = this.pushDownFilter(aEBooleanExpr, bl);
        }
        if (null != aEBooleanExpr2 && !aEBooleanExpr2.isOptimized()) {
            bl2 = bl2 || this.pushDownFilter(aEBooleanExpr2, bl);
        }
        return bl2;
    }

    private boolean pushDownOr(AEOr aEOr, boolean bl) throws ErrorException {
        assert (null != aEOr);
        boolean bl2 = this.doPushDownFilter(aEOr, bl);
        this.setFilterOptimized(aEOr);
        return bl2;
    }

    private boolean processJoin(final PushdownInfo pushdownInfo) throws ErrorException {
        AEBinaryRelationalExpr aEBinaryRelationalExpr = pushdownInfo.m_joinNode;
        assert (aEBinaryRelationalExpr instanceof AEJoin || aEBinaryRelationalExpr instanceof AECrossJoin);
        AEJoin.AEJoinType aEJoinType = null;
        boolean bl = false;
        if (aEBinaryRelationalExpr instanceof AEJoin) {
            aEJoinType = ((AEJoin)aEBinaryRelationalExpr).getJoinType();
        } else {
            bl = true;
        }
        if (AEJoin.AEJoinType.FULL_OUTER_JOIN == aEJoinType) {
            return false;
        }
        pushdownInfo.m_isInLeftSubTree = true;
        if (bl || AEJoin.AEJoinType.INNER_JOIN == aEJoinType || !pushdownInfo.m_inOuterJoinCond && AEJoin.AEJoinType.LEFT_OUTER_JOIN == aEJoinType || pushdownInfo.m_inOuterJoinCond && AEJoin.AEJoinType.RIGHT_OUTER_JOIN == aEJoinType) {
            AETreeWalker.walk(aEBinaryRelationalExpr.getLeftOperand(), new AETreeWalker.Action<Void>(){

                @Override
                public void act(IAENode iAENode) throws ErrorException {
                    if (iAENode instanceof AENamedRelationalExpr) {
                        String string = ((AENamedRelationalExpr)iAENode).getQTableName().toString();
                        if (pushdownInfo.m_foundRelExprs.remove(string)) {
                            pushdownInfo.m_foundRelExprInLeft = true;
                        }
                        if (iAENode instanceof AESubQuery) {
                            this.skipChildren();
                        }
                    }
                }
            });
        }
        if (0 == pushdownInfo.m_foundRelExprs.size()) {
            return true;
        }
        pushdownInfo.m_isInLeftSubTree = false;
        if (bl || AEJoin.AEJoinType.INNER_JOIN == aEJoinType || !pushdownInfo.m_inOuterJoinCond && AEJoin.AEJoinType.RIGHT_OUTER_JOIN == aEJoinType || pushdownInfo.m_inOuterJoinCond && AEJoin.AEJoinType.LEFT_OUTER_JOIN == aEJoinType) {
            AETreeWalker.walk(aEBinaryRelationalExpr.getRightOperand(), new AETreeWalker.Action<Void>(){

                @Override
                public void act(IAENode iAENode) throws ErrorException {
                    if (iAENode instanceof AENamedRelationalExpr) {
                        String string = ((AENamedRelationalExpr)iAENode).getQTableName().toString();
                        pushdownInfo.m_foundRelExprs.remove(string);
                    }
                    if (iAENode instanceof AESubQuery) {
                        this.skipChildren();
                    }
                }
            });
        }
        return 0 == pushdownInfo.m_foundRelExprs.size();
    }

    private void clearOptimizationFlags(IAEStatement iAEStatement) throws ErrorException {
        AETreeWalker.walk(iAEStatement, new AETreeWalker.Action<Void>(){

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AEBooleanExpr) {
                    ((AEBooleanExpr)iAENode).setIsOptimized(false);
                }
            }
        });
    }

    private boolean convertOuterJoin(IAEStatement iAEStatement) throws ErrorException {
        if (iAEStatement instanceof AEQuery) {
            return this.convertOuterJoin(((AEQuery)iAEStatement).getOperand(), new HashSet<AERelationalExpr>());
        }
        if (iAEStatement instanceof AEInsert) {
            return this.convertOuterJoin(((AEInsert)iAEStatement).getRelationalExpr(), new HashSet<AERelationalExpr>());
        }
        return false;
    }

    private boolean convertOuterJoin(AERelationalExpr aERelationalExpr, Set<AERelationalExpr> set) throws ErrorException {
        if (aERelationalExpr instanceof AESelect) {
            return this.convertOuterJoinForSelectNode((AESelect)aERelationalExpr, set);
        }
        if (aERelationalExpr instanceof AEJoin) {
            return this.convertOuterJoinForJoinNode((AEJoin)aERelationalExpr, set);
        }
        if (aERelationalExpr instanceof AECrossJoin) {
            AECrossJoin aECrossJoin = (AECrossJoin)aERelationalExpr;
            return this.convertOuterJoin(aECrossJoin.getLeftOperand(), new HashSet<AERelationalExpr>(set)) | this.convertOuterJoin(aECrossJoin.getRightOperand(), set);
        }
        if (aERelationalExpr instanceof AEAggregate) {
            return false;
        }
        if (aERelationalExpr instanceof AEUnaryRelationalExpr) {
            return this.convertOuterJoin(((AEUnaryRelationalExpr)aERelationalExpr).getOperand(), set);
        }
        return false;
    }

    private boolean convertOuterJoinForSelectNode(AESelect aESelect, Set<AERelationalExpr> set) throws ErrorException {
        AEBooleanExpr aEBooleanExpr = aESelect.getCondition();
        set.addAll(this.extractNullRejected(aEBooleanExpr));
        return this.convertOuterJoin(aESelect.getOperand(), set);
    }

    private boolean convertOuterJoinForJoinNode(AEJoin aEJoin, Set<AERelationalExpr> set) throws ErrorException {
        switch (aEJoin.getJoinType()) {
            case INNER_JOIN: {
                set.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoin(aEJoin.getLeftOperand(), new HashSet<AERelationalExpr>(set)) | this.convertOuterJoin(aEJoin.getRightOperand(), set);
            }
            case LEFT_OUTER_JOIN: {
                Object object;
                if (set.contains(aEJoin.getRightOperand()) && null != (object = this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin))) {
                    this.convertOuterJoinForJoinNode((AEJoin)object, set);
                    return true;
                }
                object = new HashSet<AERelationalExpr>(set);
                object.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoin(aEJoin.getLeftOperand(), set) | this.convertOuterJoin(aEJoin.getRightOperand(), (Set<AERelationalExpr>)object);
            }
            case RIGHT_OUTER_JOIN: {
                Object object;
                if (set.contains(aEJoin.getLeftOperand()) && null != (object = this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin))) {
                    this.convertOuterJoinForJoinNode((AEJoin)object, set);
                    return true;
                }
                object = new HashSet<AERelationalExpr>(set);
                object.addAll(this.extractNullRejected(aEJoin.getJoinCondition()));
                return this.convertOuterJoin(aEJoin.getLeftOperand(), (Set<AERelationalExpr>)object) | this.convertOuterJoin(aEJoin.getRightOperand(), set);
            }
            case FULL_OUTER_JOIN: {
                AEJoin aEJoin2 = null;
                if (set.contains(aEJoin.getLeftOperand())) {
                    aEJoin2 = set.contains(aEJoin.getRightOperand()) ? this.convertJoinType(AEJoin.AEJoinType.INNER_JOIN, aEJoin) : this.convertJoinType(AEJoin.AEJoinType.LEFT_OUTER_JOIN, aEJoin);
                } else if (set.contains(aEJoin.getRightOperand())) {
                    aEJoin2 = this.convertJoinType(AEJoin.AEJoinType.RIGHT_OUTER_JOIN, aEJoin);
                }
                if (null != aEJoin2) {
                    this.convertOuterJoinForJoinNode(aEJoin2, set);
                    return true;
                }
                return this.convertOuterJoin(aEJoin.getLeftOperand(), new HashSet<AERelationalExpr>(set)) | this.convertOuterJoin(aEJoin.getRightOperand(), set);
            }
        }
        return false;
    }

    private AEJoin convertJoinType(AEJoin.AEJoinType aEJoinType, AEJoin aEJoin) {
        switch (aEJoin.getJoinType()) {
            case LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: {
                if (AEJoin.AEJoinType.INNER_JOIN != aEJoinType) {
                    throw new IllegalArgumentException();
                }
            }
            case FULL_OUTER_JOIN: {
                IAENode iAENode = aEJoin.getParent();
                if (iAENode instanceof AEUnaryRelationalExpr) {
                    AEUnaryRelationalExpr aEUnaryRelationalExpr = (AEUnaryRelationalExpr)iAENode;
                    AEJoin aEJoin2 = new AEJoin(aEJoinType, aEJoin.getLeftOperand(), aEJoin.getRightOperand(), aEJoin.getJoinCondition());
                    aEUnaryRelationalExpr.setOperand(aEJoin2);
                    aEJoin2.setParent(aEUnaryRelationalExpr);
                    return aEJoin2;
                }
                if (iAENode instanceof AEBinaryRelationalExpr) {
                    AEBinaryRelationalExpr aEBinaryRelationalExpr = (AEBinaryRelationalExpr)iAENode;
                    AEJoin aEJoin3 = new AEJoin(aEJoinType, aEJoin.getLeftOperand(), aEJoin.getRightOperand(), aEJoin.getJoinCondition());
                    if (aEBinaryRelationalExpr.getLeftOperand() == aEJoin) {
                        aEBinaryRelationalExpr.setLeftOperand(aEJoin3);
                    } else {
                        assert (aEBinaryRelationalExpr.getRightOperand() == aEJoin) : "JOIN node must be a LEFT or RIGHT child of its binary parent";
                        aEBinaryRelationalExpr.setRightOperand(aEJoin3);
                    }
                    aEJoin3.setParent(aEBinaryRelationalExpr);
                    return aEJoin3;
                }
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    private void postProcess(IAEStatement iAEStatement) throws ErrorException {
        AETreeWalker aETreeWalker = new AETreeWalker(iAEStatement);
        while (aETreeWalker.hasNext()) {
            AERelationalExpr aERelationalExpr;
            IAENode iAENode = aETreeWalker.next();
            if (iAENode instanceof AEJoin) {
                aERelationalExpr = (AEJoin)iAENode;
                if (((AEJoin)aERelationalExpr).isOuterJoin() || !(((AEJoin)aERelationalExpr).getJoinCondition() instanceof AEBooleanTrue)) continue;
                AETreeManipulator.convertJoinToCrossJoin((AEJoin)aERelationalExpr);
                aETreeWalker = new AETreeWalker(iAEStatement);
                continue;
            }
            if (!(iAENode instanceof AESelect)) continue;
            aERelationalExpr = (AESelect)iAENode;
            if (((AESelect)aERelationalExpr).getCondition() instanceof AEBooleanTrue) {
                AETreeManipulator.removeSelect((AESelect)aERelationalExpr);
                aETreeWalker = new AETreeWalker(iAEStatement);
                continue;
            }
            if (!(((AEUnaryRelationalExpr)aERelationalExpr).getOperand() instanceof AECrossJoin)) continue;
            AETreeManipulator.convertCrossJoinToInnerJoin((AECrossJoin)((AEUnaryRelationalExpr)aERelationalExpr).getOperand(), (AESelect)aERelationalExpr);
            aETreeWalker = new AETreeWalker(iAEStatement);
        }
    }

    private boolean childOfSearchedWhenClause(AEBooleanExpr aEBooleanExpr) {
        IAENode iAENode = aEBooleanExpr.getParent();
        while (iAENode instanceof AEBooleanExpr) {
            iAENode = iAENode.getParent();
        }
        return iAENode instanceof AESearchedWhenClause;
    }

    private Set<String> extractRelationalExprs(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        assert (null != aEBooleanExpr);
        final HashSet<String> hashSet = new HashSet<String>();
        AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEColumnReference aEColumnReference) {
                hashSet.add(aEColumnReference.getNamedRelationalExpr().getQTableName().toString());
                return null;
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                }
                return null;
            }
        };
        aEBooleanExpr.acceptVisitor(aEDefaultVisitor);
        return hashSet;
    }

    private Set<AERelationalExpr> extractNullRejected(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        return aEBooleanExpr.acceptVisitor(new NullRejectVisitor());
    }

    private void setFilterOptimized(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        AETreeWalker.walk(aEBooleanExpr, new AETreeWalker.Action<Void>(){

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AEBooleanExpr) {
                    ((AEBooleanExpr)iAENode).setIsOptimized(true);
                } else if (iAENode instanceof AESubQuery || iAENode instanceof AEValueSubQuery) {
                    this.skipChildren();
                }
            }
        });
    }

    private class PushdownInfo {
        public AEBinaryRelationalExpr m_joinNode;
        public boolean m_foundRelExprInLeft;
        public boolean m_isInLeftSubTree;
        public boolean m_inOuterJoinCond;
        public Set<String> m_foundRelExprs;

        public PushdownInfo(AEBinaryRelationalExpr aEBinaryRelationalExpr, Set<String> set, boolean bl) {
            this.m_joinNode = aEBinaryRelationalExpr;
            this.m_foundRelExprInLeft = false;
            this.m_isInLeftSubTree = true;
            this.m_foundRelExprs = set;
            this.m_inOuterJoinCond = bl;
        }
    }
}

