/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aetree.relation;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.Iterator;

public class AEJoin
extends AEBinaryRelationalExpr {
    private AEJoinType m_joinType;
    private AEBooleanExpr m_joinCondition;

    public AEJoin(AEJoinType aEJoinType, AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2) {
        this(aEJoinType, aERelationalExpr, aERelationalExpr2, null);
    }

    public AEJoin(AEJoinType aEJoinType, AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, AEBooleanExpr aEBooleanExpr) {
        super(aERelationalExpr, aERelationalExpr2);
        if (null == aEJoinType) {
            throw new IllegalArgumentException("Arguments to AEJoin may not be null.");
        }
        this.m_joinType = aEJoinType;
        this.m_joinCondition = aEBooleanExpr;
        if (null != aEBooleanExpr) {
            this.m_joinCondition.setParent(this);
        }
    }

    private AEJoin(AEJoin aEJoin) {
        super(aEJoin);
        this.m_joinType = aEJoin.m_joinType;
        this.m_joinCondition = null == aEJoin.m_joinCondition ? null : aEJoin.m_joinCondition.copy();
    }

    public AEBooleanExpr getJoinCondition() {
        return this.m_joinCondition;
    }

    public void setJoinCondition(AEBooleanExpr aEBooleanExpr) {
        aEBooleanExpr.setParent(this);
        this.m_joinCondition = aEBooleanExpr;
    }

    public AEJoinType getJoinType() {
        return this.m_joinType;
    }

    public boolean isOuterJoin() {
        return this.m_joinType != AEJoinType.INNER_JOIN;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEJoin)) {
            return false;
        }
        AEJoin aEJoin = (AEJoin)iAENode;
        return aEJoin.m_joinType == this.m_joinType && aEJoin.m_joinCondition.isEquivalent(this.m_joinCondition) && aEJoin.getLeftOperand().isEquivalent(this.getLeftOperand()) && aEJoin.getRightOperand().isEquivalent(this.getRightOperand());
    }

    @Override
    public AEJoin copy() {
        return new AEJoin(this);
    }

    @Override
    public String getLogString() {
        return super.getLogString() + ": " + this.m_joinType.name();
    }

    @Override
    protected IAENode getChild(int n) {
        switch (n) {
            case 0: {
                return this.getLeftOperand();
            }
            case 1: {
                return this.getRightOperand();
            }
            case 2: {
                return this.m_joinCondition;
            }
        }
        throw new IndexOutOfBoundsException("" + n);
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
        AEDefaultVisitor<Void> aEDefaultVisitor = new AEDefaultVisitor<Void>(){

            @Override
            public Void visit(AEColumnReference aEColumnReference) throws ErrorException {
                if (!aEColumnReference.isOuterReference()) {
                    AEJoin.this.getLeftOperand().setDataNeeded(aEColumnReference.getNamedRelationalExpr(), aEColumnReference.getColumnNum());
                    AEJoin.this.getRightOperand().setDataNeeded(aEColumnReference.getNamedRelationalExpr(), aEColumnReference.getColumnNum());
                } else {
                    aEColumnReference.getNamedRelationalExpr().setDataNeeded(aEColumnReference.getNamedRelationalExpr(), aEColumnReference.getColumnNum());
                }
                return null;
            }

            @Override
            public Void visit(AEProxyColumn aEProxyColumn) throws ErrorException {
                aEProxyColumn.getRelationalExpr().setDataNeeded(aEProxyColumn.getRelationalExpr(), aEProxyColumn.getColumnNumber());
                return null;
            }

            @Override
            public Void visit(AESubQuery aESubQuery) throws ErrorException {
                for (int i = 0; i < aESubQuery.getColumnCount(); ++i) {
                    aESubQuery.setDataNeeded(aESubQuery, i);
                }
                aESubQuery.setDataNeededOnChild();
                return null;
            }

            @Override
            public Void visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
                AERelationalExpr aERelationalExpr = aEValueSubQuery.getQueryExpression();
                for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
                    aERelationalExpr.setDataNeeded(aERelationalExpr, i);
                }
                aERelationalExpr.setDataNeededOnChild();
                return null;
            }

            @Override
            public Void visit(AEInPredicate aEInPredicate) throws ErrorException {
                if (aEInPredicate.getRightOperand() instanceof AERelationalExpr) {
                    AERelationalExpr aERelationalExpr = (AERelationalExpr)aEInPredicate.getRightOperand();
                    for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
                        aERelationalExpr.setDataNeeded(aERelationalExpr, i);
                    }
                    aERelationalExpr.setDataNeededOnChild();
                    return this.defaultVisit(aEInPredicate.getLeftOperand());
                }
                return this.defaultVisit(aEInPredicate);
            }

            @Override
            public Void visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
                AERelationalExpr aERelationalExpr = aEExistsPredicate.getOperand();
                for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
                    aERelationalExpr.setDataNeeded(aERelationalExpr, i);
                }
                aERelationalExpr.setDataNeededOnChild();
                return null;
            }

            @Override
            public Void visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
                AERelationalExpr aERelationalExpr = aEQuantifiedComparison.getRightOperand();
                for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
                    aERelationalExpr.setDataNeeded(aERelationalExpr, i);
                }
                aERelationalExpr.setDataNeededOnChild();
                return this.defaultVisit(aEQuantifiedComparison.getLeftOperand());
            }

            @Override
            protected Void defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    iterator.next().acceptVisitor(this);
                }
                return null;
            }
        };
        this.m_joinCondition.acceptVisitor(aEDefaultVisitor);
        super.setDataNeededOnChild();
    }

    public static enum AEJoinType {
        INNER_JOIN("INNER JOIN"),
        LEFT_OUTER_JOIN("LEFT JOIN"),
        RIGHT_OUTER_JOIN("RIGHT JOIN"),
        FULL_OUTER_JOIN("FULL JOIN");

        private String m_stringVal;

        private AEJoinType(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

