/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aetree.statement;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class AEParameterContainer {
    private static final Comparator<AEParameter> PARAM_COMPARATOR = new Comparator<AEParameter>(){

        @Override
        public int compare(AEParameter aEParameter, AEParameter aEParameter2) {
            return aEParameter.getIndex() - aEParameter2.getIndex();
        }
    };
    private List<AEParameter> m_dynParams = new ArrayList<AEParameter>();

    public List<AEParameter> getParameters() {
        return Collections.unmodifiableList(this.m_dynParams);
    }

    public void initialize(IAEStatement iAEStatement) {
        AETreeWalker aETreeWalker = new AETreeWalker(iAEStatement);
        while (aETreeWalker.hasNext()) {
            IAENode iAENode = aETreeWalker.next();
            if (!(iAENode instanceof AEParameter)) continue;
            this.m_dynParams.add((AEParameter)iAENode);
        }
        Collections.sort(this.m_dynParams, PARAM_COMPARATOR);
    }
}

