/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.metadatautil;

import com.simba.cassandra.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.simba.cassandra.sqlengine.aeprocessor.metadatautil.SqlTypes;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

class AETypeNormalizer {
    private static Map<SqlTypes, SqlTypes[]> s_normalizeSequence = new EnumMap<SqlTypes, SqlTypes[]>(SqlTypes.class);
    private Set<SqlTypes> m_disabledSet = EnumSet.noneOf(SqlTypes.class);
    private AECoercionProperties m_properties;

    public AETypeNormalizer(AECoercionProperties aECoercionProperties) {
        this.m_properties = aECoercionProperties;
    }

    public int normalizeType(int n) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(n);
        SqlTypes sqlTypes2 = this.normalizeType(sqlTypes);
        if (sqlTypes2 == null) {
            throw SQLEngineExceptionFactory.invalidOperationException("Can not normalize type: all available coercion type is disabled.");
        }
        return sqlTypes2.getSqlType();
    }

    public SqlTypes normalizeType(SqlTypes sqlTypes) throws ErrorException {
        if (sqlTypes == null) {
            throw new NullPointerException("Normalize sql type failed.");
        }
        if (!this.m_disabledSet.contains((Object)sqlTypes)) {
            return sqlTypes;
        }
        assert (s_normalizeSequence.containsKey((Object)sqlTypes));
        for (SqlTypes sqlTypes2 : s_normalizeSequence.get((Object)sqlTypes)) {
            if (this.m_disabledSet.contains((Object)sqlTypes2)) continue;
            return sqlTypes2;
        }
        return null;
    }

    public SqlTypes fitBinaryOrCharType(SqlTypes sqlTypes, long l) throws ErrorException {
        if (l < 0L) {
            throw new IllegalArgumentException("Wrong column length: " + l);
        }
        if (sqlTypes.isBinary()) {
            return this.fitBinaryType(sqlTypes, l);
        }
        if (sqlTypes.isChar()) {
            return this.fitCharType(sqlTypes, l);
        }
        if (sqlTypes.isWChar()) {
            return this.fitWCharType(sqlTypes, l);
        }
        throw new IllegalArgumentException("Only binary or char type is acceptable: actual type: " + sqlTypes.name());
    }

    private SqlTypes fitCharType(SqlTypes sqlTypes, long l) throws ErrorException {
        assert (sqlTypes.isChar() && l >= 0L);
        switch (sqlTypes) {
            case SQL_LONGVARCHAR: {
                return sqlTypes;
            }
            case SQL_VARCHAR: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_VARCHAR, SqlTypes.SQL_LONGVARCHAR}, l);
            }
            case SQL_CHAR: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_CHAR, SqlTypes.SQL_VARCHAR, SqlTypes.SQL_LONGVARCHAR}, l);
            }
        }
        throw new IllegalArgumentException("Invalid operation for upWCharType: type: " + sqlTypes.name() + "column length: " + l);
    }

    private SqlTypes fitWCharType(SqlTypes sqlTypes, long l) throws ErrorException {
        assert (sqlTypes.isWChar() && l >= 0L);
        switch (sqlTypes) {
            case SQL_WLONGVARCHAR: {
                return sqlTypes;
            }
            case SQL_WVARCHAR: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WLONGVARCHAR}, l);
            }
            case SQL_WCHAR: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_WCHAR, SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WLONGVARCHAR}, l);
            }
        }
        throw new IllegalArgumentException("Invalid operation for upWCharType: type: " + sqlTypes.name() + "column length: " + l);
    }

    private SqlTypes fitBinaryType(SqlTypes sqlTypes, long l) throws ErrorException {
        assert (sqlTypes.isBinary() && l >= 0L);
        switch (sqlTypes) {
            case SQL_LONGVARBINARY: {
                return sqlTypes;
            }
            case SQL_VARBINARY: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_VARBINARY, SqlTypes.SQL_LONGVARBINARY}, l);
            }
            case SQL_BINARY: {
                return this.upBinaryOrCharType(new SqlTypes[]{SqlTypes.SQL_BINARY, SqlTypes.SQL_VARBINARY, SqlTypes.SQL_LONGVARBINARY}, l);
            }
        }
        throw new IllegalArgumentException("Invalid operation for upWCharType: type: " + sqlTypes.name() + "column length: " + l);
    }

    public boolean isTypeDisabled(SqlTypes sqlTypes) {
        return this.m_disabledSet.contains((Object)sqlTypes);
    }

    public void disableType(int n) throws ErrorException {
        SqlTypes sqlTypes = SqlTypes.getValueOf(n);
        this.m_disabledSet.add(sqlTypes);
    }

    private SqlTypes upBinaryOrCharType(SqlTypes[] sqlTypesArray, long l) throws ErrorException {
        assert (sqlTypesArray.length >= 1);
        SqlTypes sqlTypes = null;
        for (int i = 0; i < sqlTypesArray.length; ++i) {
            if (this.isTypeDisabled(sqlTypesArray[i]) || this.getMaxBinaryOrCharLen(sqlTypes = sqlTypesArray[i]) < l) continue;
            return sqlTypes;
        }
        if (sqlTypes == null) {
            throw SQLEngineExceptionFactory.invalidOperationException("Can not normalize type: all available coercion type is disabled.");
        }
        return sqlTypes;
    }

    private long getMaxBinaryOrCharLen(SqlTypes sqlTypes) {
        switch (sqlTypes) {
            case SQL_BINARY: {
                return this.m_properties.getMaxBinaryLength();
            }
            case SQL_VARBINARY: {
                return this.m_properties.getMaxVarbinaryLength();
            }
            case SQL_LONGVARBINARY: {
                return Long.MAX_VALUE;
            }
            case SQL_CHAR: {
                return this.m_properties.getMaxCharLength();
            }
            case SQL_VARCHAR: {
                return this.m_properties.getMaxVarcharlength();
            }
            case SQL_LONGVARCHAR: {
                return Long.MAX_VALUE;
            }
            case SQL_WCHAR: {
                return this.m_properties.getMaxWcharlength();
            }
            case SQL_WVARCHAR: {
                return this.m_properties.getMaxWvarcharLength();
            }
            case SQL_WLONGVARCHAR: {
                return Long.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid argument passed in getMaxBinaryOrCharLen: " + sqlTypes.name());
    }

    static {
        s_normalizeSequence.put(SqlTypes.SQL_BINARY, new SqlTypes[]{SqlTypes.SQL_VARBINARY, SqlTypes.SQL_LONGVARBINARY});
        s_normalizeSequence.put(SqlTypes.SQL_VARBINARY, new SqlTypes[]{SqlTypes.SQL_LONGVARBINARY, SqlTypes.SQL_BINARY});
        s_normalizeSequence.put(SqlTypes.SQL_LONGVARBINARY, new SqlTypes[]{SqlTypes.SQL_VARBINARY, SqlTypes.SQL_BINARY});
        s_normalizeSequence.put(SqlTypes.SQL_CHAR, new SqlTypes[]{SqlTypes.SQL_VARCHAR, SqlTypes.SQL_LONGVARCHAR, SqlTypes.SQL_WCHAR, SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WLONGVARCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_VARCHAR, new SqlTypes[]{SqlTypes.SQL_LONGVARCHAR, SqlTypes.SQL_CHAR, SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WLONGVARCHAR, SqlTypes.SQL_WCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_LONGVARCHAR, new SqlTypes[]{SqlTypes.SQL_VARCHAR, SqlTypes.SQL_CHAR, SqlTypes.SQL_WLONGVARCHAR, SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_WCHAR, new SqlTypes[]{SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WLONGVARCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_WVARCHAR, new SqlTypes[]{SqlTypes.SQL_WLONGVARCHAR, SqlTypes.SQL_WCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_WLONGVARCHAR, new SqlTypes[]{SqlTypes.SQL_WVARCHAR, SqlTypes.SQL_WCHAR});
        s_normalizeSequence.put(SqlTypes.SQL_BIT, new SqlTypes[]{SqlTypes.SQL_TINYINT, SqlTypes.SQL_SMALLINT, SqlTypes.SQL_INTEGER, SqlTypes.SQL_BIGINT});
        s_normalizeSequence.put(SqlTypes.SQL_TINYINT, new SqlTypes[]{SqlTypes.SQL_SMALLINT, SqlTypes.SQL_INTEGER, SqlTypes.SQL_BIGINT});
        s_normalizeSequence.put(SqlTypes.SQL_SMALLINT, new SqlTypes[]{SqlTypes.SQL_INTEGER, SqlTypes.SQL_BIGINT, SqlTypes.SQL_TINYINT});
        s_normalizeSequence.put(SqlTypes.SQL_INTEGER, new SqlTypes[]{SqlTypes.SQL_BIGINT, SqlTypes.SQL_SMALLINT, SqlTypes.SQL_TINYINT});
        s_normalizeSequence.put(SqlTypes.SQL_BIGINT, new SqlTypes[]{SqlTypes.SQL_INTEGER, SqlTypes.SQL_SMALLINT, SqlTypes.SQL_TINYINT});
        s_normalizeSequence.put(SqlTypes.SQL_NUMERIC, new SqlTypes[]{SqlTypes.SQL_DECIMAL});
        s_normalizeSequence.put(SqlTypes.SQL_DECIMAL, new SqlTypes[]{SqlTypes.SQL_NUMERIC});
        s_normalizeSequence.put(SqlTypes.SQL_REAL, new SqlTypes[]{SqlTypes.SQL_FLOAT, SqlTypes.SQL_DOUBLE});
        s_normalizeSequence.put(SqlTypes.SQL_FLOAT, new SqlTypes[]{SqlTypes.SQL_DOUBLE, SqlTypes.SQL_REAL});
        s_normalizeSequence.put(SqlTypes.SQL_DOUBLE, new SqlTypes[]{SqlTypes.SQL_FLOAT, SqlTypes.SQL_REAL});
        s_normalizeSequence.put(SqlTypes.SQL_DATE, new SqlTypes[]{SqlTypes.SQL_TIMESTAMP});
        s_normalizeSequence.put(SqlTypes.SQL_TIMESTAMP, new SqlTypes[0]);
        s_normalizeSequence.put(SqlTypes.SQL_TIME, new SqlTypes[0]);
        s_normalizeSequence.put(SqlTypes.SQL_GUID, new SqlTypes[0]);
    }
}

