/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.dsiext.dataengine.ddl;

import com.simba.cassandra.sqlengine.dsiext.dataengine.ddl.TableConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UniqueConstraint
extends TableConstraint {
    private static final TableConstraint.ConstraintType CONSTRAINT_TYPE = TableConstraint.ConstraintType.UNIQUE;
    private Set<String> m_uniqueColumns;

    public UniqueConstraint(String string, Collection<String> collection) {
        super(string);
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException("Unique constraint requires at least one column");
        }
        this.m_uniqueColumns = new HashSet<String>();
        this.m_uniqueColumns.addAll(collection);
    }

    public Set<String> getUniqueColumns() {
        return this.m_uniqueColumns;
    }

    @Override
    public TableConstraint.ConstraintType getType() {
        return CONSTRAINT_TYPE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UNIQUE COLUMN(");
        Object[] objectArray = this.m_uniqueColumns.toArray(new String[this.m_uniqueColumns.size()]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            stringBuilder.append((String)object);
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

