/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.dsiext.dataengine.metadata;

import com.simba.cassandra.dsi.core.impl.DSIDriver;
import com.simba.cassandra.dsi.dataengine.filters.IFilter;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.dsi.utilities.DSIMessageKey;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.simba.cassandra.sqlengine.dsiext.dataengine.Identifier;
import com.simba.cassandra.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

public class DSIExtTablesMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private final ILogger m_logger;
    private Identifier m_curRow = null;

    @Deprecated
    public DSIExtTablesMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, boolean bl) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, bl);
        this.m_logger = iLogger;
    }

    public DSIExtTablesMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, boolean bl, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, bl, list);
        this.m_logger = iLogger;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getCatalog(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getSchema(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData("TABLE", dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.hasNextProcedureOrTable();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_curRow = this.getNextProcedureOrTable();
        return this.m_curRow != null;
    }

    protected Identifier getCurrentTable() {
        return this.m_curRow;
    }
}

