/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;

public final class SqlExactNumDataWrapper
extends DefaultSqlDataWrapper {
    private BigDecimal m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlExactNumDataWrapper(int n) {
        assert (n == 3 || n == 2);
        this.m_type = n;
    }

    @Override
    public BigDecimal getExactNumber() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setExactNumber(BigDecimal bigDecimal) {
        this.m_isSet = true;
        this.m_data = bigDecimal;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            BigDecimal bigDecimal = null;
            switch (dataWrapper.getType()) {
                case 3: {
                    bigDecimal = dataWrapper.getDecimal();
                    break;
                }
                case 2: {
                    bigDecimal = dataWrapper.getNumeric();
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setExactNumber(bigDecimal);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case 3: {
                dataWrapper.setDecimal(this.m_data);
                break;
            }
            case 2: {
                dataWrapper.setNumeric(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

