/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;

public final class SqlRealDataWrapper
extends DefaultSqlDataWrapper {
    private float m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public float getReal() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? 1.0f : 0.0f;
    }

    @Override
    public void setReal(float f) {
        this.m_isSet = true;
        this.m_data = f;
        this.m_isNull = false;
    }

    @Override
    public void setSmallInt(int n) {
        this.m_isSet = true;
        this.m_data = n;
        this.m_isNull = false;
    }

    @Override
    public void setTinyInt(short s) {
        this.m_isSet = true;
        this.m_data = s;
        this.m_isNull = false;
    }

    private float getData() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
        return this.m_data;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    case 7: {
                        this.setReal(dataWrapper.getReal().floatValue());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(7);
            return;
        }
        dataWrapper.setReal(this.m_data);
    }
}

