/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.sql.Time;

public final class SqlTimeDataWrapper
extends DefaultSqlDataWrapper {
    private Time m_data;
    private boolean m_isSet = false;

    @Override
    public Time getTime() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return 92;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setTime(Time time) {
        this.m_isSet = true;
        this.m_data = time;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case 92: {
                    this.setTime(dataWrapper.getTime());
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setTime(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

