/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.sql.Timestamp;

public final class SqlTimestampDataWrapper
extends DefaultSqlDataWrapper {
    private Timestamp m_data;
    private boolean m_isSet = false;

    @Override
    public Timestamp getTimestamp() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return 93;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setTimestamp(Timestamp timestamp) {
        this.m_isSet = true;
        this.m_data = timestamp;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case 93: {
                    this.setTimestamp(dataWrapper.getTimestamp());
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setTimestamp(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

