/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;

public final class ETDataRequest {
    private final ISqlDataWrapper m_data;
    private long m_offset;
    private long m_maxBytes;
    private boolean m_isDefault;
    private IColumn m_metadata = null;

    public ETDataRequest(IColumn iColumn) {
        this(0L, -1L, iColumn);
    }

    public ETDataRequest(long l, long l2, IColumn iColumn) {
        this.m_offset = l;
        this.m_maxBytes = l2;
        this.m_isDefault = false;
        this.m_metadata = iColumn;
        this.m_data = DefaultSqlDataWrapper.initializeFromSqlType(iColumn.getTypeMetadata().getType());
    }

    public ETDataRequest(ETDataRequest eTDataRequest) {
        this.m_data = eTDataRequest.m_data;
        this.m_offset = eTDataRequest.m_offset;
        this.m_maxBytes = eTDataRequest.m_maxBytes;
        this.m_isDefault = eTDataRequest.m_isDefault;
        this.m_metadata = eTDataRequest.m_metadata;
    }

    public ISqlDataWrapper getData() {
        return this.m_data;
    }

    public TypeMetadata getMetadata() {
        return this.m_metadata.getTypeMetadata();
    }

    public IColumn getColumn() {
        return this.m_metadata;
    }

    public long getOffset() {
        return this.m_offset;
    }

    public long getMaxSize() {
        return this.m_maxBytes;
    }

    public boolean isDefault() {
        return this.m_isDefault;
    }

    public void setIsDefault(boolean bl) {
        this.m_isDefault = bl;
    }

    public void setMaxBytes(long l) {
        if (-1L != l) {
            if (0L > l) {
                throw new IllegalArgumentException("Invalid max retrieval size: " + l);
            }
            if (this.m_metadata.getTypeMetadata().isCharacterType()) assert (0L <= (l &= 0xFFFFFFFFFFFFFFFEL));
        }
        this.m_maxBytes = l;
    }

    public void setOffset(long l) {
        if (l < 0L || this.m_metadata.getTypeMetadata().isCharacterType() && l % 2L != 0L) {
            throw new IllegalArgumentException("invalid offset: " + l);
        }
        this.m_offset = l;
    }
}

