/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.relation.join;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.IETNode;
import com.simba.cassandra.sqlengine.executor.etree.IETNodeVisitor;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.join.RowFile;
import com.simba.cassandra.sqlengine.executor.etree.temptable.IRowView;
import com.simba.cassandra.sqlengine.executor.etree.temptable.InMemTable;
import com.simba.cassandra.sqlengine.executor.etree.temptable.LongDataStore;
import com.simba.cassandra.sqlengine.executor.etree.temptable.TemporaryFile;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSliceBuilder;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.simba.cassandra.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;

class HHJoinDataSource
extends ETRelationalExpr
implements IRowView {
    private final boolean m_isRowFile;
    private final LongDataStore m_longDataStore;
    private ETRelationalExpr m_relation = null;
    private final IColumn[] m_columns;
    private RowFile m_file = null;
    private boolean m_isOpen;
    private ColumnSliceArray m_row;
    private int m_maxDataSize;
    private boolean[] m_isLongData;

    public HHJoinDataSource(ETRelationalExpr eTRelationalExpr, LongDataStore longDataStore, boolean[] blArray, IColumn[] iColumnArray, int n) {
        super(blArray);
        this.m_isRowFile = false;
        this.m_longDataStore = longDataStore;
        this.m_relation = eTRelationalExpr;
        this.m_columns = iColumnArray;
        this.m_isOpen = false;
        this.m_maxDataSize = n;
        this.m_row = ColumnSliceBuilder.buildColumnSliceArray(iColumnArray, blArray, 1, this.m_maxDataSize);
        this.setIsLongData();
    }

    public HHJoinDataSource(LongDataStore longDataStore, boolean[] blArray, IColumn[] iColumnArray, int n, File file, ILogger iLogger) throws ErrorException {
        super(blArray);
        this.m_isRowFile = true;
        this.m_file = new RowFile(iColumnArray, file, iLogger, n, blArray);
        this.m_columns = iColumnArray;
        this.m_longDataStore = longDataStore;
        this.m_isOpen = false;
        this.m_maxDataSize = n;
        this.setIsLongData();
    }

    @Override
    public void close(boolean bl) {
        this.m_isOpen = false;
        if (this.m_isRowFile) {
            this.m_file.reset();
        }
    }

    public void destroy() {
        this.m_isOpen = false;
        if (this.m_isRowFile) {
            this.m_file.close();
        } else {
            this.close(false);
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void reset() throws ErrorException {
        if (this.m_isRowFile) {
            this.m_file.reset();
        } else {
            this.m_relation.reset();
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        throw new IllegalStateException();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isNull(int n) {
        if (this.m_isRowFile) {
            return this.m_file.isNull(n);
        }
        return this.m_row.get(n).isNull(0);
    }

    @Override
    public long getBigInt(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getBigInt(n);
        }
        return this.m_row.get(n).getBigInt(0);
    }

    @Override
    public BigDecimal getExactNumber(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getExactNumber(n);
        }
        return this.m_row.get(n).getExactNum(0);
    }

    @Override
    public double getDouble(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getDouble(n);
        }
        return this.m_row.get(n).getDouble(0);
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getFileMarker(n);
        }
        return this.m_row.get(n).getFileMarker(0);
    }

    @Override
    public float getReal(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getReal(n);
        }
        return this.m_row.get(n).getReal(0);
    }

    @Override
    public boolean getBoolean(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getBoolean(n);
        }
        return this.m_row.get(n).getBoolean(0);
    }

    @Override
    public String getString(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getString(n);
        }
        return this.m_row.get(n).getString(0);
    }

    @Override
    public Date getDate(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getDate(n);
        }
        return this.m_row.get(n).getDate(0);
    }

    @Override
    public Time getTime(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getTime(n);
        }
        return this.m_row.get(n).getTime(0);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getTimestamp(n);
        }
        return this.m_row.get(n).getTimestamp(0);
    }

    @Override
    public UUID getGuid(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getGuid(n);
        }
        return this.m_row.get(n).getGuid(0);
    }

    @Override
    public int getInteger(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getInteger(n);
        }
        return this.m_row.get(n).getInteger(0);
    }

    @Override
    public short getSmallInt(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getSmallInt(n);
        }
        return this.m_row.get(n).getSmallInt(0);
    }

    @Override
    public byte getTinyInt(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getTinyInt(n);
        }
        return this.m_row.get(n).getTinyInt(0);
    }

    @Override
    public byte[] getBytes(int n) {
        if (this.m_isRowFile) {
            return this.m_file.getBytes(n);
        }
        return this.m_row.get(n).getBytes(0);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_columns[n];
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.length;
    }

    @Override
    public long getRowCount() throws ErrorException {
        if (this.m_isRowFile) {
            return this.m_file.getRowCount();
        }
        return this.m_relation.getRowCount();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_isOpen = true;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_isRowFile) {
            return DataRetrievalUtil.retrieveFromRowView(n, this.m_isLongData[n], eTDataRequest, (IRowView)this.m_file, this.m_longDataStore);
        }
        return this.m_relation.retrieveData(n, eTDataRequest);
    }

    public void writeRows(InMemTable inMemTable, List<Integer> list, int n) throws ErrorException {
        if (!this.m_isRowFile) {
            throw new IllegalStateException();
        }
        this.m_file.writeRows(inMemTable, list, n);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_isRowFile) {
            return this.m_file.moveToNextRow();
        }
        boolean bl = this.m_relation.move();
        if (bl) {
            this.loadRow();
        }
        return bl;
    }

    private void loadRow() throws ErrorException {
        block16: for (IColumnSlice iColumnSlice : this.m_row) {
            ETDataRequest eTDataRequest = new ETDataRequest(0L, this.m_maxDataSize, this.m_columns[iColumnSlice.columnNumber()]);
            if (IColumnSlice.ColumnSliceType.FILE_MARKER == iColumnSlice.getType()) {
                TemporaryFile.FileMarker fileMarker = this.m_longDataStore.put(iColumnSlice.columnNumber(), this.m_relation);
                if (null == fileMarker) {
                    iColumnSlice.setNull(0);
                    continue;
                }
                iColumnSlice.setFileMarker(0, fileMarker);
                continue;
            }
            this.m_relation.retrieveData(iColumnSlice.columnNumber(), eTDataRequest);
            if (eTDataRequest.getData().isNull()) {
                iColumnSlice.setNull(0);
                continue;
            }
            switch (iColumnSlice.getType()) {
                case BIGINT: {
                    iColumnSlice.setBigInt(0, eTDataRequest.getData().getBigInt().longValue());
                    continue block16;
                }
                case BINARY: {
                    iColumnSlice.setBytes(0, eTDataRequest.getData().getBinary());
                    continue block16;
                }
                case BOOLEAN: {
                    iColumnSlice.setBoolean(0, eTDataRequest.getData().getBoolean());
                    continue block16;
                }
                case CHAR: {
                    iColumnSlice.setString(0, eTDataRequest.getData().getChar());
                    continue block16;
                }
                case DATE: {
                    iColumnSlice.setDate(0, eTDataRequest.getData().getDate());
                    continue block16;
                }
                case DOUBLE: {
                    iColumnSlice.setDouble(0, eTDataRequest.getData().getDouble());
                    continue block16;
                }
                case EXACT_NUM: {
                    iColumnSlice.setExactNum(0, eTDataRequest.getData().getExactNumber());
                    continue block16;
                }
                case GUID: {
                    iColumnSlice.setGuid(0, eTDataRequest.getData().getGuid());
                    continue block16;
                }
                case INTEGER: {
                    iColumnSlice.setInteger(0, (int)eTDataRequest.getData().getInteger());
                    continue block16;
                }
                case REAL: {
                    iColumnSlice.setReal(0, eTDataRequest.getData().getReal());
                    continue block16;
                }
                case SMALLINT: {
                    iColumnSlice.setSmallInt(0, (short)eTDataRequest.getData().getSmallInt());
                    continue block16;
                }
                case TIME: {
                    iColumnSlice.setTime(0, eTDataRequest.getData().getTime());
                    continue block16;
                }
                case TIMESTAMP: {
                    iColumnSlice.setTimestamp(0, eTDataRequest.getData().getTimestamp());
                    continue block16;
                }
                case TINYINT: {
                    iColumnSlice.setTinyInt(0, (byte)eTDataRequest.getData().getTinyInt());
                    continue block16;
                }
            }
            throw new IllegalStateException("Unknown ColumnSliceType.");
        }
    }

    private void setIsLongData() {
        this.m_isLongData = new boolean[this.m_columns.length];
        for (int i = 0; i < this.m_columns.length; ++i) {
            boolean bl;
            this.m_isLongData[i] = bl = ColumnSizeCalculator.isLongData(this.m_columns[i], this.m_maxDataSize);
        }
    }
}

