/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.statement;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.IETNode;
import com.simba.cassandra.sqlengine.executor.etree.IETNodeVisitor;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETTable;
import com.simba.cassandra.sqlengine.executor.etree.statement.RowCountStatement;
import com.simba.cassandra.sqlengine.executor.etree.value.ETParameter;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.DiagState;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ETInsert
extends RowCountStatement {
    private long m_rowcount = -1L;
    private ETTable m_table;
    private ArrayList<Pair<Integer, ETDataRequest>> m_insertColumnReqs;
    private ETRelationalExpr m_dataRelation;
    private int[] m_defaultCols;
    private short[] m_tgtTableTypes;

    public ETInsert(ETTable eTTable, List<Pair<Integer, IColumn>> list, ETRelationalExpr eTRelationalExpr, Map<Integer, ETParameter> map) throws ErrorException {
        super(map);
        if (eTTable == null || list == null || eTRelationalExpr == null) {
            throw new NullPointerException();
        }
        if (list.size() != eTRelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("column count mismatch");
        }
        this.m_table = eTTable;
        this.m_dataRelation = eTRelationalExpr;
        this.m_tgtTableTypes = new short[this.m_table.getColumnCount()];
        HashSet<Integer> hashSet = new HashSet<Integer>(this.m_table.getColumnCount());
        for (int i = 0; i < this.m_tgtTableTypes.length; ++i) {
            this.m_tgtTableTypes[i] = this.m_table.getColumn(i).getTypeMetadata().getType();
            hashSet.add(i);
        }
        this.m_insertColumnReqs = new ArrayList(list.size());
        for (Pair<Integer, IColumn> object2 : list) {
            ETDataRequest n2 = new ETDataRequest(object2.value());
            this.m_insertColumnReqs.add(new Pair<Integer, ETDataRequest>(object2.key(), n2));
            hashSet.remove(object2.key());
        }
        this.m_defaultCols = new int[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.m_defaultCols[n++] = n2;
        }
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close() {
        if (null != this.m_dataRelation) {
            try {
                this.m_dataRelation.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_dataRelation = null;
        }
        if (null != this.m_table) {
            try {
                this.m_table.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_table = null;
        }
        this.m_insertColumnReqs = null;
        this.m_defaultCols = null;
        this.m_tgtTableTypes = null;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_rowcount;
    }

    @Override
    public void startBatch() throws ErrorException {
        this.m_table.open(CursorType.FORWARD_ONLY);
        this.m_table.onStartDMLBatch(DSIExtJResultSet.DMLType.INSERT, -1L);
    }

    @Override
    public void endBatch() throws ErrorException {
        this.m_table.onFinishDMLBatch();
        this.m_table.close(false);
    }

    @Override
    public void execute() throws ErrorException {
        this.m_dataRelation.open(CursorType.FORWARD_ONLY);
        ParameterGeneratedValues parameterGeneratedValues = this.getGeneratedParameters();
        if (parameterGeneratedValues != null) {
            this.m_table.setGeneratedParameters(parameterGeneratedValues);
        }
        this.insertData();
        this.m_dataRelation.close(false);
    }

    @Override
    public Iterator<? extends IETNode> getChildItr() {
        return new AbstractList<IETNode>(){

            @Override
            public IETNode get(int n) {
                return ETInsert.this.getChild(n);
            }

            @Override
            public int size() {
                return ETInsert.this.getNumChildren();
            }
        }.iterator();
    }

    @Override
    public IResultSet getGeneratedResult() throws ErrorException {
        return this.m_table.getGeneratedResult();
    }

    private void insertData() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        this.m_rowcount = 0L;
        while (this.m_dataRelation.move()) {
            this.m_table.appendRow();
            for (int n : this.m_defaultCols) {
                dataWrapper.setNull(this.m_tgtTableTypes[n]);
                if (!this.m_table.writeData(n, dataWrapper, 0L, true)) continue;
                throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, n);
            }
            for (int i = 0; i < this.m_insertColumnReqs.size(); ++i) {
                Pair<Integer, ETDataRequest> pair = this.m_insertColumnReqs.get(i);
                int n = pair.key();
                ETDataRequest eTDataRequest = pair.value();
                eTDataRequest.setOffset(0L);
                eTDataRequest.setIsDefault(false);
                boolean bl = true;
                while (bl) {
                    bl = this.m_dataRelation.retrieveData(i, eTDataRequest);
                    boolean bl2 = false;
                    long l = 0L;
                    if (eTDataRequest.isDefault()) {
                        bl2 = true;
                        dataWrapper.setNull(this.m_tgtTableTypes[n]);
                    } else {
                        eTDataRequest.getData().retrieveData(dataWrapper);
                        l = eTDataRequest.getOffset();
                    }
                    if (this.m_table.writeData(n, dataWrapper, l, bl2)) {
                        throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, n);
                    }
                    if (!bl) continue;
                    eTDataRequest.setOffset(eTDataRequest.getOffset() + eTDataRequest.getMaxSize());
                }
            }
            this.m_table.onFinishRowUpdate();
            ++this.m_rowcount;
        }
    }

    private IETNode getChild(int n) {
        switch (n) {
            case 0: {
                return this.m_table;
            }
            case 1: {
                return this.m_dataRelation;
            }
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }
}

