/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.temptable;

import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.utilities.ExternalAlgorithmUtil;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TemporaryFile {
    private static final String PACKAGE_NAME = "com.simba.sqlengine.executor.etree.temptable";
    private static final String CLASS_NAME = "TemporaryFile";
    private ILogger m_logger;
    private RandomAccessFile m_file;
    private File m_fileUnderneath;
    private long m_currentPosition;
    private boolean m_appending = false;
    private long m_appendStart = 0L;

    public TemporaryFile(File file, ILogger iLogger) throws ErrorException {
        this.m_logger = iLogger;
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, file);
        }
        this.m_fileUnderneath = ExternalAlgorithmUtil.createTempFile(file, this.m_logger);
        try {
            this.m_file = new RandomAccessFile(this.m_fileUnderneath, "rw");
            this.m_currentPosition = this.m_file.getFilePointer();
        }
        catch (Exception exception) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, CLASS_NAME, "Could not create temporary file.");
            }
            throw SQLEngineExceptionFactory.failedToCreateFile(this.m_fileUnderneath.getAbsolutePath(), exception.getLocalizedMessage());
        }
    }

    public void append(byte[] byArray) throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (!this.m_appending) {
            this.m_appending = true;
            this.m_appendStart = this.m_currentPosition;
        }
        this.doPut(byArray);
    }

    public FileMarker generateFileMarker() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (!this.m_appending) {
            throw new IllegalStateException("Attempt to generate a file marker before calling append");
        }
        this.m_appending = false;
        long l = this.m_currentPosition - this.m_appendStart;
        return new FileMarker(this.m_appendStart, l);
    }

    public boolean isAppending() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        return this.m_appending;
    }

    public FileMarker put(byte[] byArray) throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (this.m_appending) {
            throw new IllegalStateException("Attempt to write data during an append operation.");
        }
        return this.doPut(byArray);
    }

    public byte[] get(FileMarker fileMarker) throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, fileMarker);
        }
        if (fileMarker.m_length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Requesting data that is too big to load into memory");
        }
        int n = (int)fileMarker.m_length;
        byte[] byArray = new byte[n];
        try {
            this.m_file.seek(fileMarker.m_pos);
            int n2 = 0;
            for (int i = 0; i < n && (n2 = this.m_file.read(byArray, i, n - i)) != -1; i += n2) {
            }
            if (n2 < n) {
                if (null != this.m_logger) {
                    this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "get", "Failed to read data from file.");
                }
                throw SQLEngineExceptionFactory.failedToReadData();
            }
        }
        catch (IOException iOException) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "destroy", iOException.getLocalizedMessage());
            }
            throw SQLEngineExceptionFactory.failedToReadData(iOException);
        }
        return byArray;
    }

    public void destroy() {
        block6: {
            if (null != this.m_logger) {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            }
            if (null != this.m_file) {
                try {
                    this.m_file.close();
                    this.m_file = null;
                }
                catch (IOException iOException) {
                    if (null == this.m_logger) break block6;
                    this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "destroy", iOException.getLocalizedMessage());
                }
            }
        }
        if (null != this.m_fileUnderneath) {
            if (this.m_fileUnderneath.exists() && !this.m_fileUnderneath.delete() && null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "destroy", "Cannot delete temprary file: " + this.m_fileUnderneath.getAbsolutePath());
            }
            this.m_fileUnderneath = null;
        }
    }

    private FileMarker doPut(byte[] byArray) throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        try {
            this.m_file.seek(this.m_currentPosition);
            FileMarker fileMarker = new FileMarker(this.m_currentPosition, byArray.length);
            this.m_file.write(byArray);
            this.m_currentPosition = this.m_file.getFilePointer();
            return fileMarker;
        }
        catch (IOException iOException) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "put", iOException.getLocalizedMessage());
            }
            throw SQLEngineExceptionFactory.failedToWriteData(iOException);
        }
    }

    public static class FileMarker {
        public final long m_pos;
        public final long m_length;

        public FileMarker(long l, long l2) {
            this.m_pos = l;
            this.m_length = l2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FileMarker)) {
                return false;
            }
            FileMarker fileMarker = (FileMarker)object;
            return this.m_pos == fileMarker.m_pos && this.m_length == fileMarker.m_length;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (int)(this.m_pos ^ this.m_pos >>> 32);
            n = 31 * n + (int)(this.m_length ^ this.m_length >>> 32);
            return n;
        }

        public String toString() {
            return String.format("FileMarker : [position %d], [length %d]", this.m_pos, this.m_length);
        }
    }
}

