/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.temptable.column;

import com.simba.cassandra.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.IColumnSlice;

public final class DoubleColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 40172364764569598L;
    private double[] m_data;
    private byte[] m_nullInd;
    private final int m_columnNumber;

    public DoubleColumnSlice(int n, int n2) {
        this.m_data = new double[n];
        this.m_nullInd = new byte[(n + 7) / 8];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return BitsUtil.isSet(this.m_nullInd, n);
    }

    @Override
    public void setNull(int n) {
        BitsUtil.setBit(this.m_nullInd, n);
    }

    @Override
    public double getDouble(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.DOUBLE;
    }

    @Override
    public void setDouble(int n, double d) {
        this.m_data[n] = d;
        BitsUtil.clearBit(this.m_nullInd, n);
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        DoubleColumnSlice doubleColumnSlice = (DoubleColumnSlice)iColumnSlice;
        System.arraycopy(doubleColumnSlice.m_data, n, this.m_data, n3, n2);
        BitsUtil.copy(this.m_nullInd, n3, n2, doubleColumnSlice.m_nullInd, n);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return (double)javaSize.getDoubleSize() + (double)javaSize.getByteSize() / 8.0;
    }
}

