/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.aggregatefn;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.aggregatefn.AbstractAggregator;
import com.simba.cassandra.sqlengine.executor.etree.value.aggregatefn.AbstractAggregatorFactory;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class SumAggregatorFactory
extends AbstractAggregatorFactory {
    public SumAggregatorFactory(IColumn[] iColumnArray, IColumn iColumn) {
        super(iColumnArray, iColumn);
    }

    @Override
    public AbstractAggregator createAggregator() {
        switch (this.getInputMetadata(0).getTypeMetadata().getType()) {
            case 2: 
            case 3: {
                return new SumExactNumAggregator(this);
            }
        }
        return new SumDoubleAggregator(this);
    }

    private static class SumExactNumAggregator
    extends AbstractAggregator {
        private BigDecimal m_accumulator = BigDecimal.ZERO;
        private boolean m_hasSum = false;

        public SumExactNumAggregator(AbstractAggregatorFactory abstractAggregatorFactory) {
            super(abstractAggregatorFactory);
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                this.m_accumulator = (BigDecimal)objectInputStream.readObject();
                this.m_hasSum = objectInputStream.readBoolean();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        @Override
        public byte[] serialize() throws ErrorException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(this.m_accumulator);
                objectOutputStream.writeBoolean(this.m_hasSum);
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToWriteData(exception);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
            if (!this.m_hasSum) {
                iSqlDataWrapper.setNull();
            } else {
                iSqlDataWrapper.setExactNumber(this.m_accumulator);
            }
            return false;
        }

        @Override
        public void reset() {
            this.m_accumulator = BigDecimal.ZERO;
            this.m_hasSum = false;
        }

        @Override
        public void close() {
            this.m_accumulator = null;
        }

        @Override
        protected void update() throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
            if (!iSqlDataWrapper.isNull()) {
                this.m_accumulator = this.m_accumulator.add(iSqlDataWrapper.getExactNumber());
                this.m_hasSum = true;
            }
        }

        @Override
        protected long getMemoryUsage() {
            return 1L + AbstractAggregatorFactory.BIGDECIMAL_SIZE;
        }
    }

    private static class SumDoubleAggregator
    extends AbstractAggregator {
        private double m_accumulator = 0.0;
        private boolean m_hasSum = false;

        public SumDoubleAggregator(AbstractAggregatorFactory abstractAggregatorFactory) {
            super(abstractAggregatorFactory);
        }

        @Override
        public void load(byte[] byArray) throws ErrorException {
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                this.m_accumulator = byteBuffer.getDouble();
                this.m_hasSum = 0 != byteBuffer.get();
            }
            catch (Exception exception) {
                throw SQLEngineExceptionFactory.failedToReadData(exception);
            }
        }

        @Override
        public byte[] serialize() {
            ByteBuffer byteBuffer = ByteBuffer.allocate(9);
            byteBuffer.putDouble(this.m_accumulator);
            byteBuffer.put((byte)(this.m_hasSum ? 1 : 0));
            return byteBuffer.array();
        }

        @Override
        public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
            if (this.m_hasSum) {
                iSqlDataWrapper.setDouble(this.m_accumulator);
            } else {
                iSqlDataWrapper.setNull();
            }
            return false;
        }

        @Override
        public void reset() {
            this.m_hasSum = false;
            this.m_accumulator = 0.0;
        }

        @Override
        public void close() {
        }

        @Override
        protected void update() throws ErrorException {
            ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
            if (!iSqlDataWrapper.isNull()) {
                switch (iSqlDataWrapper.getType()) {
                    case -7: 
                    case 16: {
                        if (!iSqlDataWrapper.getBoolean()) break;
                        this.m_accumulator += 1.0;
                        break;
                    }
                    case -6: {
                        this.m_accumulator += (double)iSqlDataWrapper.getTinyInt();
                        break;
                    }
                    case 5: {
                        this.m_accumulator += (double)iSqlDataWrapper.getSmallInt();
                        break;
                    }
                    case 4: {
                        this.m_accumulator += (double)iSqlDataWrapper.getInteger();
                        break;
                    }
                    case -5: {
                        this.m_accumulator += iSqlDataWrapper.getBigInt().doubleValue();
                        break;
                    }
                    case 7: {
                        this.m_accumulator += (double)iSqlDataWrapper.getReal();
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.m_accumulator += iSqlDataWrapper.getDouble();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.getInputMetadata(0).getTypeMetadata().getTypeName());
                    }
                }
                this.m_hasSum = true;
            }
        }

        @Override
        protected long getMemoryUsage() {
            return 9L;
        }
    }
}

