/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic;

import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.exceptions.ErrorException;

public abstract class AbstractTinyIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractTinyIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        short s = iSqlDataWrapper.getTinyInt();
        assert (this.m_isSigned && s <= 127 && s >= -128 || !this.m_isSigned && s >= 0 && s <= 255);
        short s2 = iSqlDataWrapper2.getTinyInt();
        assert (this.m_isSigned && s2 <= 127 && s2 >= -128 || !this.m_isSigned && s2 >= 0 && s2 <= 255);
        short s3 = this.calculate(s, s2);
        if (this.m_isSigned && s3 <= 127 && s3 >= -128 || !this.m_isSigned && s3 >= 0 && s3 <= 255) {
            eTDataRequest.getData().setTinyInt(s3);
            return false;
        }
        throw SQLEngineExceptionFactory.numArithOverflowException();
    }

    protected abstract short calculate(short var1, short var2) throws ErrorException;
}

