/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public class ETCharFn
extends ETScalarFn {
    public ETCharFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        assert (list2.get(0).getTypeMetadata().isIntegerType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            long l = iSqlDataWrapper.getInteger();
            if (l > 255L || l < 0L) {
                eTDataRequest.getData().setNull();
            } else {
                eTDataRequest.getData().setChar(String.valueOf((char)l));
            }
        }
        return false;
    }
}

