/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public final class ETLocateFn
extends ETScalarFn {
    private static final int NEEDLE_ARG = 0;
    private static final int HAYSTACK_ARG = 1;
    private static final int START_ARG = 2;
    private final boolean m_hasStartArgument;

    public ETLocateFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size() || 3 == list.size());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (list2.get(1).getTypeMetadata().isCharacterType());
        boolean bl = this.m_hasStartArgument = 3 == list.size();
        assert (!this.m_hasStartArgument || list2.get(2).getTypeMetadata().isIntegerType());
        assert (iColumn.getTypeMetadata().isIntegerType());
    }

    @Override
    public String getLogString() {
        return "ETLocateFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        int n;
        ISqlDataWrapper iSqlDataWrapper;
        long l = 0L;
        if (this.m_hasStartArgument) {
            iSqlDataWrapper = this.getArgumentData(2);
            if (iSqlDataWrapper.isNull()) {
                eTDataRequest.getData().setNull();
                return false;
            }
            long l2 = iSqlDataWrapper.getInteger();
            if (1L < l2) {
                l = l2 - 1L;
            }
        }
        iSqlDataWrapper = this.getArgumentData(1);
        assert (!this.hasMoreData(1)) : "Failed to fetch all data.";
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(0, 0L, (long)string.length() * 2L);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string2 = iSqlDataWrapper2.getChar();
        if (0 < string2.length() && !this.hasMoreData(0) && 0 <= (n = string.indexOf(string2, (int)Math.min(l, (long)string.length())))) {
            eTDataRequest.getData().setInteger(n + 1);
            return false;
        }
        eTDataRequest.getData().setInteger(0L);
        return false;
    }
}

