/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public final class ETQuarterFn
extends ETScalarFn {
    public ETQuarterFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        if (1 != list.size() || 1 != list2.size()) {
            throw new IllegalArgumentException("Invalid Number of arguments for QUARTER scalar function.");
        }
        short s = list2.get(0).getTypeMetadata().getType();
        if (91 != s) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public String getLogString() {
        return "ETQuarterFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            int n = 1 + iSqlDataWrapper.getDate().getMonth() / 3;
            assert (1 <= n && n <= 4);
            eTDataRequest.getData().setSmallInt(n);
        }
        return false;
    }
}

