/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.Warning;
import com.simba.cassandra.support.WarningCode;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public class ETUCaseFn
extends ETScalarFn {
    public ETUCaseFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        boolean bl = this.hasMoreData(0);
        long l = eTDataRequest.getOffset() / 2L;
        long l2 = this.getResultMetadata().getColumnLength();
        if (l + (long)string.length() > l2) {
            bl = false;
            int n = (int)(l2 - l);
            string = string.substring(0, n);
            IWarningListener iWarningListener = this.getWarningListener();
            iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
        }
        eTDataRequest.getData().setChar(string.toUpperCase());
        return bl;
    }
}

