/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.materializer;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aemanipulator.CNFIterator;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.executor.conversions.ConversionUtil;
import com.simba.cassandra.sqlengine.executor.conversions.ISqlConverter;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.join.ETConditionedJoin;
import com.simba.cassandra.sqlengine.executor.etree.relation.join.HybridHashJoinAlgorithm;
import com.simba.cassandra.sqlengine.executor.etree.relation.join.IJoinAlgorithmAdapter;
import com.simba.cassandra.sqlengine.executor.etree.relation.join.NBJoinAlgorithm;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.simba.cassandra.sqlengine.executor.etree.value.ETColumnRef;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.MaterializerBase;
import com.simba.cassandra.sqlengine.executor.materializer.MaterializerContext;
import com.simba.cassandra.sqlengine.executor.queryplan.IQueryPlan;
import com.simba.cassandra.sqlengine.utilities.ExternalAlgorithmUtil;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ETJoinMaterializer
extends MaterializerBase<ETRelationalExpr> {
    private AERelationalExpr m_leftAeRelation;
    private AERelationalExpr m_rightAeRelation;
    private ETRelationalExpr m_leftEtRelation;
    private ETRelationalExpr m_rightEtRelation;
    private ETRelationalExpr m_leftRelationWrapper = null;
    private ETRelationalExpr m_rightRelationWrapper = null;
    private AEBooleanExpr m_joinCond;
    private AEJoin.AEJoinType m_joinType;
    private boolean[] m_joinDataNeeded;
    private AEBinaryRelationalExpr m_join;
    private AENamedRelationalExpr m_leftTable;
    private AENamedRelationalExpr m_rightTable;
    private final ETRelationalExprMaterializer m_operandMaterializer;

    public ETJoinMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext, AEJoin aEJoin, ETRelationalExprMaterializer eTRelationalExprMaterializer) throws ErrorException {
        super(iQueryPlan, materializerContext);
        this.m_join = aEJoin;
        this.m_leftAeRelation = aEJoin.getLeftOperand();
        this.m_rightAeRelation = aEJoin.getRightOperand();
        this.m_joinCond = aEJoin.getJoinCondition();
        this.m_joinType = aEJoin.getJoinType();
        this.m_operandMaterializer = eTRelationalExprMaterializer;
        this.setJoinTable();
        this.setDataNeeded();
    }

    public ETJoinMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext, AECrossJoin aECrossJoin, ETRelationalExprMaterializer eTRelationalExprMaterializer) {
        super(iQueryPlan, materializerContext);
        this.m_join = aECrossJoin;
        this.m_leftAeRelation = aECrossJoin.getLeftOperand();
        this.m_rightAeRelation = aECrossJoin.getRightOperand();
        this.m_joinCond = new AEBooleanTrue();
        this.m_joinType = AEJoin.AEJoinType.INNER_JOIN;
        this.m_operandMaterializer = eTRelationalExprMaterializer;
        this.setJoinTable();
        this.setDataNeeded();
    }

    public ETRelationalExpr materialize() throws ErrorException {
        this.m_leftEtRelation = this.m_leftAeRelation.acceptVisitor(this.m_operandMaterializer);
        this.m_rightEtRelation = this.m_rightAeRelation.acceptVisitor(this.m_operandMaterializer);
        ETConditionedJoin.Builder builder = new ETConditionedJoin.Builder(this.m_leftEtRelation, this.m_rightEtRelation, this.getContext().getCancelState(), this.m_joinDataNeeded);
        this.m_leftRelationWrapper = builder.getLeftRelationWrapper();
        this.m_rightRelationWrapper = builder.getRightRelationWrapper();
        this.getContext().setJoinOperandWrapper(this.m_leftAeRelation, this.m_leftRelationWrapper);
        this.getContext().setJoinOperandWrapper(this.m_rightAeRelation, this.m_rightRelationWrapper);
        ETJoinConditionMaterializer eTJoinConditionMaterializer = new ETJoinConditionMaterializer(this.getQueryPlan(), this.getContext(), new ETJoinCondValueExprMaterializer(this.getQueryPlan(), this.getContext()));
        builder.setJoinAlgorithm(this.buildJoinAlgorithmAdapter());
        builder.setJoinCondition(this.m_joinCond.acceptVisitor(eTJoinConditionMaterializer));
        ETConditionedJoin eTConditionedJoin = builder.build();
        this.getContext().setMaterializedRelation(this.m_join, eTConditionedJoin);
        if (this.m_leftTable != null) {
            this.getContext().setJoinMapping(this.m_leftTable, this.m_join, 0);
        } else {
            assert (this.m_leftAeRelation instanceof AEJoin || this.m_leftAeRelation instanceof AECrossJoin);
            this.getContext().updateMapping((AEBinaryRelationalExpr)this.m_leftAeRelation, this.m_join, 0);
        }
        if (this.m_rightTable != null) {
            this.getContext().setJoinMapping(this.m_rightTable, this.m_join, this.m_leftAeRelation.getColumnCount());
        } else {
            assert (this.m_rightAeRelation instanceof AEJoin || this.m_rightAeRelation instanceof AECrossJoin);
            this.getContext().updateMapping((AEBinaryRelationalExpr)this.m_rightAeRelation, this.m_join, this.m_leftAeRelation.getColumnCount());
        }
        return eTConditionedJoin;
    }

    private IJoinAlgorithmAdapter buildJoinAlgorithmAdapter() throws ErrorException {
        if (this.m_joinCond instanceof AEBooleanTrue) {
            return new NBJoinAlgorithm(this.m_leftEtRelation, this.m_rightEtRelation, AEJoin.AEJoinType.INNER_JOIN, this.getContext().getExternalAlgorithmProperties(), this.getContext().getCancelState(), this.getContext().getLog());
        }
        LinkedList<Pair<Integer, Integer>> linkedList = new LinkedList<Pair<Integer, Integer>>();
        LinkedList<IColumn> linkedList2 = new LinkedList<IColumn>();
        LinkedList<ISqlConverter> linkedList3 = new LinkedList<ISqlConverter>();
        LinkedList<ISqlConverter> linkedList4 = new LinkedList<ISqlConverter>();
        HashSet<AEBooleanExpr> hashSet = new HashSet<AEBooleanExpr>();
        CNFIterator cNFIterator = new CNFIterator(this.m_joinCond);
        int n = this.getContext().getExternalAlgorithmProperties().getCellMemoryLimit();
        while (cNFIterator.hasNext()) {
            Pair<Integer, Integer> pair;
            IColumn iColumn;
            IColumn iColumn2;
            AEComparison aEComparison;
            AEBooleanExpr aEBooleanExpr = cNFIterator.next();
            if (!(aEBooleanExpr instanceof AEComparison) || ((AEComparison)aEBooleanExpr).getComparisonOp() != AEComparisonType.EQUAL || !((aEComparison = (AEComparison)aEBooleanExpr).getLeftOperand().getChild(0) instanceof AEColumnReference) || !(aEComparison.getRightOperand().getChild(0) instanceof AEColumnReference)) continue;
            AEColumnReference aEColumnReference = (AEColumnReference)aEComparison.getLeftOperand().getChild(0);
            AEColumnReference aEColumnReference2 = (AEColumnReference)aEComparison.getRightOperand().getChild(0);
            Pair<Boolean, Integer> pair2 = this.resolveColumn(aEColumnReference);
            Pair<Boolean, Integer> pair3 = this.resolveColumn(aEColumnReference2);
            if (pair2 == null || pair3 == null || pair2.key() == pair3.key()) continue;
            IColumn iColumn3 = aEComparison.getCoercedColumnMetadata();
            if (pair2.key().booleanValue()) {
                iColumn2 = aEColumnReference.getColumn();
                iColumn = aEColumnReference2.getColumn();
                pair = new Pair<Integer, Integer>(pair2.value(), pair3.value());
            } else {
                iColumn2 = aEColumnReference2.getColumn();
                iColumn = aEColumnReference.getColumn();
                pair = new Pair<Integer, Integer>(pair3.value(), pair2.value());
            }
            if (ColumnSizeCalculator.isLongData(iColumn2, n) || ColumnSizeCalculator.isLongData(iColumn, n)) continue;
            linkedList.add(pair);
            linkedList2.add(iColumn3);
            linkedList3.add(ConversionUtil.createConverter(this.getContext().getSqlConverterGenerator(), iColumn2, iColumn3));
            linkedList4.add(ConversionUtil.createConverter(this.getContext().getSqlConverterGenerator(), iColumn, iColumn3));
            hashSet.add(aEBooleanExpr);
        }
        if (linkedList.size() == 0) {
            return new NBJoinAlgorithm(this.m_leftEtRelation, this.m_rightEtRelation, this.m_joinType, this.getContext().getExternalAlgorithmProperties(), this.getContext().getCancelState(), this.getContext().getLog());
        }
        cNFIterator = new CNFIterator(this.m_joinCond);
        while (cNFIterator.hasNext()) {
            if (!hashSet.contains(cNFIterator.next())) continue;
            cNFIterator.remove();
        }
        this.m_joinCond = cNFIterator.getExpr();
        if (this.m_joinCond == null) {
            this.m_joinCond = new AEBooleanTrue();
        }
        assert (this.m_join instanceof AEJoin);
        ((AEJoin)this.m_join).setJoinCondition(this.m_joinCond);
        return this.getHHJoinAlgorithmAdapter(linkedList, linkedList2, linkedList3, linkedList4);
    }

    private IJoinAlgorithmAdapter getHHJoinAlgorithmAdapter(List<Pair<Integer, Integer>> list, List<IColumn> list2, List<ISqlConverter> list3, List<ISqlConverter> list4) throws ErrorException {
        int[] nArray = new int[list.size()];
        int[] nArray2 = new int[list.size()];
        int n = 0;
        for (Pair<Integer, Integer> pair : list) {
            nArray[n] = pair.key();
            nArray2[n] = pair.value();
            ++n;
        }
        ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties = this.getContext().getExternalAlgorithmProperties();
        return new HybridHashJoinAlgorithm(this.m_leftEtRelation, this.m_rightEtRelation, nArray, nArray2, this.m_joinType, externalAlgorithmProperties, list2, list3, list4, this.getContext().getCancelState(), this.m_joinDataNeeded);
    }

    private void setDataNeeded() {
        this.m_joinDataNeeded = new boolean[this.m_join.getColumnCount()];
        for (int i = 0; i < this.m_joinDataNeeded.length; ++i) {
            if (!this.m_join.getDataNeeded(i)) continue;
            this.m_joinDataNeeded[i] = true;
        }
    }

    private void setJoinTable() {
        if (!(this.m_leftAeRelation instanceof AEJoin) && !(this.m_leftAeRelation instanceof AECrossJoin)) {
            this.m_leftTable = this.getNamedRelation(this.m_leftAeRelation);
        }
        if (!(this.m_rightAeRelation instanceof AEJoin) && !(this.m_rightAeRelation instanceof AECrossJoin)) {
            this.m_rightTable = this.getNamedRelation(this.m_rightAeRelation);
        }
    }

    private AENamedRelationalExpr getNamedRelation(AERelationalExpr aERelationalExpr) {
        while (!(aERelationalExpr instanceof AENamedRelationalExpr)) {
            if (aERelationalExpr instanceof AESelect) {
                aERelationalExpr = ((AESelect)aERelationalExpr).getOperand();
                continue;
            }
            throw new IllegalStateException("Invalid AETree structure");
        }
        return (AENamedRelationalExpr)aERelationalExpr;
    }

    private Pair<Boolean, Integer> resolveColumn(AEColumnReference aEColumnReference) {
        AENamedRelationalExpr aENamedRelationalExpr = aEColumnReference.getNamedRelationalExpr();
        if (aENamedRelationalExpr == this.m_leftTable) {
            return new Pair<Boolean, Integer>(true, aEColumnReference.getColumnNum());
        }
        if (aENamedRelationalExpr == this.m_rightTable) {
            return new Pair<Boolean, Integer>(false, aEColumnReference.getColumnNum());
        }
        Pair<AEBinaryRelationalExpr, Integer> pair = this.getContext().resolveJoinRelation(aEColumnReference.getNamedRelationalExpr());
        if (null == pair || pair.key() != this.m_leftAeRelation && pair.key() != this.m_rightAeRelation) {
            return null;
        }
        return new Pair<Boolean, Integer>(pair.key() == this.m_leftAeRelation, pair.value() + aEColumnReference.getColumnNum());
    }

    private static class ETJoinConditionRelationMaterializer
    extends ETRelationalExprMaterializer {
        private final ETValueExprMaterializer m_valueExprMaterializer;
        private final ETJoinConditionMaterializer m_booleanExprMaterializer;

        public ETJoinConditionRelationMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext, ETJoinCondValueExprMaterializer eTJoinCondValueExprMaterializer, ETJoinConditionMaterializer eTJoinConditionMaterializer) {
            super(iQueryPlan, materializerContext);
            this.m_valueExprMaterializer = eTJoinCondValueExprMaterializer;
            this.m_booleanExprMaterializer = eTJoinConditionMaterializer;
        }

        @Override
        protected ETValueExprMaterializer createValueExprMaterializer() {
            return this.m_valueExprMaterializer;
        }

        @Override
        protected ETBoolExprMaterializer createBooleanExprMaterializer() {
            return this.m_booleanExprMaterializer;
        }
    }

    private class ETJoinCondValueExprMaterializer
    extends ETValueExprMaterializer {
        private final ETRelationalExprMaterializer m_relationalExprMat;

        public ETJoinCondValueExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
            super(iQueryPlan, materializerContext);
            this.m_relationalExprMat = new ETJoinConditionRelationMaterializer(this.getQueryPlan(), this.getContext(), this, new ETJoinConditionMaterializer(this.getQueryPlan(), this.getContext(), this));
        }

        @Override
        public ETValueExpr visit(AEColumnReference aEColumnReference) throws ErrorException {
            Pair pair = ETJoinMaterializer.this.resolveColumn(aEColumnReference);
            if (null == pair) {
                return super.visit(aEColumnReference);
            }
            return new ETColumnRef((Boolean)pair.key() != false ? ETJoinMaterializer.this.m_leftRelationWrapper : ETJoinMaterializer.this.m_rightRelationWrapper, (Integer)pair.value(), false);
        }

        @Override
        protected ETRelationalExprMaterializer createRelationalExprMaterializer() {
            return this.m_relationalExprMat;
        }
    }

    private static class ETJoinConditionMaterializer
    extends ETBoolExprMaterializer {
        private final ETJoinCondValueExprMaterializer m_valueExprMaterializer;
        private final ETRelationalExprMaterializer m_relationalExprMat;

        public ETJoinConditionMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext, ETJoinCondValueExprMaterializer eTJoinCondValueExprMaterializer) {
            super(iQueryPlan, materializerContext);
            this.m_valueExprMaterializer = eTJoinCondValueExprMaterializer;
            this.m_relationalExprMat = new ETJoinConditionRelationMaterializer(this.getQueryPlan(), this.getContext(), this.m_valueExprMaterializer, this);
        }

        @Override
        protected ETValueExprMaterializer createValueExprMaterializer() {
            return this.m_valueExprMaterializer;
        }

        @Override
        protected ETRelationalExprMaterializer createRelationalExprMaterializer() {
            return this.m_relationalExprMat;
        }
    }
}

