/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.materializer;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AECreateTable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.simba.cassandra.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineMemoryException;
import com.simba.cassandra.sqlengine.executor.IStatementExecutor;
import com.simba.cassandra.sqlengine.executor.ProcedureExecutor;
import com.simba.cassandra.sqlengine.executor.StatementExecutor;
import com.simba.cassandra.sqlengine.executor.conversions.SqlConverterGenerator;
import com.simba.cassandra.sqlengine.executor.etree.ETMemoryManager;
import com.simba.cassandra.sqlengine.executor.etree.ETResourceManager;
import com.simba.cassandra.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETProcedure;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETTable;
import com.simba.cassandra.sqlengine.executor.etree.statement.ETProcedureCall;
import com.simba.cassandra.sqlengine.executor.etree.statement.ETQuery;
import com.simba.cassandra.sqlengine.executor.etree.statement.ETSearchedDelete;
import com.simba.cassandra.sqlengine.executor.etree.statement.IETStatement;
import com.simba.cassandra.sqlengine.executor.etree.statement.RowCountStatement;
import com.simba.cassandra.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETDmlMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETTableMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.IStatementMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.MaterializerContext;
import com.simba.cassandra.sqlengine.executor.queryplan.IQueryPlan;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.exceptions.ErrorException;
import com.simba.cassandra.support.exceptions.InvalidOperationException;

public class ETStatementMaterializer
extends AEDefaultVisitor<IETStatement>
implements IStatementMaterializer {
    private IQueryPlan m_plan;
    private MaterializerContext m_materializerContext;

    public ETStatementMaterializer(SqlConverterGenerator sqlConverterGenerator, IWarningListener iWarningListener, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger) {
        this.m_materializerContext = new MaterializerContext(sqlConverterGenerator, iWarningListener, sqlDataEngineContext, new ETResourceManager(iLogger), iLogger);
    }

    @Override
    public IStatementExecutor materialize(IQueryPlan iQueryPlan) throws ErrorException {
        this.m_plan = iQueryPlan;
        IETStatement iETStatement = null;
        IAEStatement iAEStatement = null;
        try {
            iAEStatement = iQueryPlan.getAETree();
            iAEStatement.notifyDataNeeded();
            iETStatement = iAEStatement.acceptVisitor(this);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
        ETMemoryManager eTMemoryManager = ETMemoryManager.createMemoryManager(iETStatement);
        this.m_materializerContext.getResourceManager().registerResource(eTMemoryManager);
        IStatementExecutor iStatementExecutor = iETStatement instanceof ETProcedureCall ? new ProcedureExecutor((ETProcedureCall)iETStatement, (AEProcedureCall)iAEStatement, this.m_materializerContext) : new StatementExecutor(iETStatement, iAEStatement, this.m_materializerContext.getResourceManager(), this.m_materializerContext.getCancelState());
        return iStatementExecutor;
    }

    @Override
    public ETQuery visit(AEQuery aEQuery) throws ErrorException {
        MaterializerContext materializerContext = this.m_materializerContext;
        ETRelationalExpr eTRelationalExpr = aEQuery.getOperand().acceptVisitor(new ETRelationalExprMaterializer(this.m_plan, materializerContext));
        return new ETQuery(eTRelationalExpr, this.m_materializerContext.getParameters());
    }

    @Override
    public IETStatement visit(AEProcedureCall aEProcedureCall) throws ErrorException {
        MaterializerContext materializerContext = this.m_materializerContext;
        ETProcedure eTProcedure = (ETProcedure)aEProcedureCall.getOperand().acceptVisitor(new ETRelationalExprMaterializer(this.m_plan, materializerContext));
        return new ETProcedureCall(eTProcedure, this.m_materializerContext.getParameters());
    }

    @Override
    public IETStatement visit(AECreateTable aECreateTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("CREATE statement");
    }

    @Override
    public IETStatement visit(AEDelete aEDelete) throws ErrorException {
        MaterializerContext materializerContext = this.m_materializerContext;
        ETTable eTTable = aEDelete.getTable().acceptVisitor(new ETTableMaterializer(this.m_plan, materializerContext));
        ETBooleanExpr eTBooleanExpr = aEDelete.getCondition().acceptVisitor(new ETBoolExprMaterializer(this.m_plan, materializerContext));
        return new ETSearchedDelete(eTTable, eTBooleanExpr, materializerContext.getParameters());
    }

    @Override
    public IETStatement visit(AEDropTable aEDropTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("DROP statement");
    }

    @Override
    public RowCountStatement visit(AEInsert aEInsert) throws ErrorException {
        return aEInsert.acceptVisitor(new ETDmlMaterializer(this.m_plan, this.m_materializerContext));
    }

    @Override
    public IETStatement visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
        return new ETDmlMaterializer(this.m_plan, this.m_materializerContext).visit(aEInsertDefaults);
    }

    @Override
    public IETStatement visit(AEUpdate aEUpdate) throws ErrorException {
        return new ETDmlMaterializer(this.m_plan, this.m_materializerContext).visit(aEUpdate);
    }

    @Override
    protected IETStatement defaultVisit(IAENode iAENode) throws ErrorException {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iAENode + " from base AE tree builder class");
    }
}

