/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.materializer;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AENodeList;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.ScalarFunctionID;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AECastFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEDefault;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEDefaultParameter;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AENegate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AENull;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AERename;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEUnaryValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.conversions.ConversionUtil;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.IETNode;
import com.simba.cassandra.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.ArithmeticExprType;
import com.simba.cassandra.sqlengine.executor.etree.value.ETAggregateFn;
import com.simba.cassandra.sqlengine.executor.etree.value.ETBinaryArithValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.ETColumnRef;
import com.simba.cassandra.sqlengine.executor.etree.value.ETConstant;
import com.simba.cassandra.sqlengine.executor.etree.value.ETCustomScalarFn;
import com.simba.cassandra.sqlengine.executor.etree.value.ETDefault;
import com.simba.cassandra.sqlengine.executor.etree.value.ETDefaultParameter;
import com.simba.cassandra.sqlengine.executor.etree.value.ETDistinctAggregateFn;
import com.simba.cassandra.sqlengine.executor.etree.value.ETError;
import com.simba.cassandra.sqlengine.executor.etree.value.ETParameter;
import com.simba.cassandra.sqlengine.executor.etree.value.ETSearchedCase;
import com.simba.cassandra.sqlengine.executor.etree.value.ETSearchedWhenClause;
import com.simba.cassandra.sqlengine.executor.etree.value.ETSimpleCase;
import com.simba.cassandra.sqlengine.executor.etree.value.ETSimpleWhenClause;
import com.simba.cassandra.sqlengine.executor.etree.value.ETUnaryArithValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExprList;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueSubQuery;
import com.simba.cassandra.sqlengine.executor.etree.value.aggregatefn.IAggregatorFactory;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.ArithmeticFunctorFactory;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.BinaryArithmeticOperator;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.IUnaryArithmeticFunctor;
import com.simba.cassandra.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.simba.cassandra.sqlengine.executor.materializer.ETAggregateFnFactory;
import com.simba.cassandra.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.simba.cassandra.sqlengine.executor.materializer.ETScalarFnFactory;
import com.simba.cassandra.sqlengine.executor.materializer.MaterializerBase;
import com.simba.cassandra.sqlengine.executor.materializer.MaterializerContext;
import com.simba.cassandra.sqlengine.executor.queryplan.IQueryPlan;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.conv.ConversionResult;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ETValueExprMaterializer
extends MaterializerBase<ETValueExpr> {
    public ETValueExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETValueExpr visit(AEAdd aEAdd) throws ErrorException {
        return this.materializeBinArithExpr(aEAdd, ArithmeticExprType.ADDITION);
    }

    @Override
    public ETValueExpr visit(AECastFn aECastFn) throws ErrorException {
        return this.visit((AEScalarFn)aECastFn);
    }

    @Override
    public ETValueExpr visit(AEColumnReference aEColumnReference) throws ErrorException {
        AENamedRelationalExpr aENamedRelationalExpr;
        MaterializerContext materializerContext = this.getContext();
        Pair<AEBinaryRelationalExpr, Integer> pair = materializerContext.resolveJoinRelation(aENamedRelationalExpr = aEColumnReference.getNamedRelationalExpr());
        if (pair == null) {
            ETRelationalExpr eTRelationalExpr = materializerContext.getJoinOperandWrapper(aENamedRelationalExpr);
            if (eTRelationalExpr != null) {
                return new ETColumnRef(eTRelationalExpr, aEColumnReference.getColumnNum(), aEColumnReference.isOuterReference());
            }
            eTRelationalExpr = materializerContext.getMaterializedRelation(aEColumnReference.getNamedRelationalExpr());
            return new ETColumnRef(eTRelationalExpr, aEColumnReference.getColumnNum(), aEColumnReference.isOuterReference());
        }
        ETRelationalExpr eTRelationalExpr = materializerContext.getMaterializedRelation(pair.key());
        if (eTRelationalExpr == null) {
            throw new IllegalStateException("Invalid materialized sequence.");
        }
        return new ETColumnRef(eTRelationalExpr, aEColumnReference.getColumnNum() + pair.value(), aEColumnReference.isOuterReference());
    }

    @Override
    public ETValueExpr visit(AEConcat aEConcat) throws ErrorException {
        return this.materializeBinArithExpr(aEConcat, ArithmeticExprType.ADDITION);
    }

    @Override
    public ETValueExpr visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
        return this.materializeAggregateFn(aECountStarAggrFn);
    }

    @Override
    public ETValueExpr visit(AECustomScalarFn aECustomScalarFn) throws ErrorException {
        aECustomScalarFn.updateColumn();
        ETValueExprList eTValueExprList = new ETValueExprList();
        AEValueExprList aEValueExprList = aECustomScalarFn.getArguments();
        List<IColumn> list = aECustomScalarFn.getInputMetadata();
        Iterator iterator = aEValueExprList.getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
            assert (n < list.size());
            eTValueExprList.addNode(ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aEValueExpr.getColumn(), list.get(n), this.getContext()));
            ++n;
        }
        return new ETCustomScalarFn(aECustomScalarFn.getDSICustomScalarFn(), eTValueExprList, list);
    }

    @Override
    public ETValueExpr visit(AEDefault aEDefault) throws ErrorException {
        return new ETDefault();
    }

    @Override
    public ETValueExpr visit(AEDivide aEDivide) throws ErrorException {
        return this.materializeBinArithExpr(aEDivide, ArithmeticExprType.DIVISION);
    }

    @Override
    public ETValueExpr visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
        return this.materializeAggregateFn(aEGeneralAggrFn);
    }

    @Override
    public ETValueExpr visit(AELiteral aELiteral) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        ETConstant eTConstant = this.doLiteralConversion(aELiteral, conversionResult);
        if (conversionResult.getState() != null) {
            try {
                ConversionUtil.checkResult(conversionResult, this.getContext().getWarningListener(), -1, -1);
            }
            catch (ErrorException errorException) {
                return new ETError(errorException);
            }
        }
        return eTConstant;
    }

    @Override
    public ETValueExpr visit(AEMultiply aEMultiply) throws ErrorException {
        return this.materializeBinArithExpr(aEMultiply, ArithmeticExprType.MULTIPLICATION);
    }

    @Override
    public ETValueExpr visit(AENegate aENegate) throws ErrorException {
        return this.materializeUnaryArithExpr(aENegate, ArithmeticExprType.NEGATION);
    }

    @Override
    public ETValueExpr visit(AENull aENull) throws ErrorException {
        SqlCharDataWrapper sqlCharDataWrapper = new SqlCharDataWrapper(1);
        sqlCharDataWrapper.setNull();
        return new ETConstant(sqlCharDataWrapper);
    }

    @Override
    public ETValueExpr visit(AEParameter aEParameter) throws ErrorException {
        ETParameter eTParameter = new ETParameter(aEParameter.getInferredOrSetColumn());
        this.getContext().registerParameter(aEParameter.getIndex(), eTParameter);
        return eTParameter;
    }

    @Override
    public ETValueExpr visit(AEDefaultParameter aEDefaultParameter) throws ErrorException {
        return new ETDefaultParameter();
    }

    @Override
    public ETValueExpr visit(AEProxyColumn aEProxyColumn) throws ErrorException {
        MaterializerContext materializerContext = this.getContext();
        ETRelationalExpr eTRelationalExpr = materializerContext.getMaterializedRelation(aEProxyColumn.getRelationalExpr());
        if (null == eTRelationalExpr) {
            throw new NullPointerException("No materialized relation for: " + aEProxyColumn);
        }
        return new ETColumnRef(eTRelationalExpr, aEProxyColumn.getColumnNumber(), false);
    }

    @Override
    public ETValueExpr visit(AERename aERename) throws ErrorException {
        return aERename.getOperand().acceptVisitor(this);
    }

    @Override
    public ETValueExpr visit(AEScalarFn aEScalarFn) throws ErrorException {
        if (aEScalarFn.getScalarFnName().equalsIgnoreCase("CAST") && null != ((AECastFn)aEScalarFn).getFormat()) {
            throw SQLEngineExceptionFactory.unsupportedFormatClauseInCastException();
        }
        AEValueExprList aEValueExprList = aEScalarFn.getArguments();
        List<IColumn> list = aEScalarFn.getExpectedArgMetadata();
        ArrayList<ETValueExpr> arrayList = new ArrayList<ETValueExpr>(aEValueExprList.getNumChildren());
        if (aEScalarFn.getScalarFnId() == ScalarFunctionID.CAST2 || aEScalarFn.getScalarFnId() == ScalarFunctionID.CAST3 || aEScalarFn.getScalarFnId() == ScalarFunctionID.CAST4 || aEScalarFn.getScalarFnId() == ScalarFunctionID.CONVERT2 || aEScalarFn.getScalarFnId() == ScalarFunctionID.CONVERT3 || aEScalarFn.getScalarFnId() == ScalarFunctionID.CONVERT4) {
            AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(0);
            ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
            eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aEValueExpr.getColumn(), list.get(0), this.getContext());
            return eTValueExpr;
        }
        for (int i = 0; i < aEValueExprList.getNumChildren(); ++i) {
            AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(i);
            ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
            eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aEValueExpr.getColumn(), list.get(i), this.getContext());
            arrayList.add(eTValueExpr);
        }
        return ETScalarFnFactory.makeNewScalarFn(aEScalarFn, list, arrayList, this.getContext());
    }

    @Override
    public ETValueExpr visit(AESearchedCase aESearchedCase) throws ErrorException {
        Iterator iterator = aESearchedCase.getWhenClauseList().getChildItr();
        ETValueExprList eTValueExprList = new ETValueExprList();
        while (iterator.hasNext()) {
            eTValueExprList.addNode((IETNode)((AESearchedWhenClause)iterator.next()).acceptVisitor(this));
        }
        ETValueExpr eTValueExpr = aESearchedCase.getElseClause().acceptVisitor(this);
        return new ETSearchedCase(eTValueExprList, eTValueExpr);
    }

    @Override
    public ETValueExpr visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
        ETBooleanExpr eTBooleanExpr = aESearchedWhenClause.getWhenCondition().acceptVisitor(new ETBoolExprMaterializer(this.getQueryPlan(), this.getContext()));
        ETValueExpr eTValueExpr = aESearchedWhenClause.getThenExpression().acceptVisitor(this);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aESearchedWhenClause.getThenExpression().getColumn(), ((AEValueExpr)aESearchedWhenClause.getParent().getParent()).getColumn(), this.getContext());
        return new ETSearchedWhenClause(eTBooleanExpr, eTValueExpr);
    }

    @Override
    public ETValueExpr visit(AESimpleCase aESimpleCase) throws ErrorException {
        AENodeList<AESimpleWhenClause> aENodeList = aESimpleCase.getWhenClauseList();
        ETValueExprList eTValueExprList = new ETValueExprList();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        for (AESimpleWhenClause object2 : aENodeList) {
            ETValueExpr eTValueExpr = object2.acceptVisitor(this);
            eTValueExprList.addNode(eTValueExpr);
            arrayList.add(object2.getComparisonMetadata());
        }
        ETValueExpr eTValueExpr = aESimpleCase.getCaseOperand().acceptVisitor(this);
        ETValueExpr eTValueExpr2 = aESimpleCase.getElseOperand().acceptVisitor(this);
        return new ETSimpleCase(eTValueExpr, aESimpleCase.getCaseOperand().getColumn(), eTValueExprList, eTValueExpr2, arrayList, this.getContext());
    }

    @Override
    public ETValueExpr visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
        ETValueExpr eTValueExpr = aESimpleWhenClause.getWhenExpression().acceptVisitor(this);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aESimpleWhenClause.getWhenExpression().getColumn(), aESimpleWhenClause.getComparisonMetadata(), this.getContext());
        ETValueExpr eTValueExpr2 = aESimpleWhenClause.getThenExpression().acceptVisitor(this);
        eTValueExpr2 = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr2, aESimpleWhenClause.getThenExpression().getColumn(), ((AEValueExpr)aESimpleWhenClause.getParent().getParent()).getColumn(), this.getContext());
        return new ETSimpleWhenClause(eTValueExpr, eTValueExpr2);
    }

    @Override
    public ETValueExpr visit(AESubtract aESubtract) throws ErrorException {
        return this.materializeBinArithExpr(aESubtract, ArithmeticExprType.SUBTRACTION);
    }

    @Override
    public ETValueExpr visit(AEValueSubQuery aEValueSubQuery) throws ErrorException {
        ETRelationalExprMaterializer eTRelationalExprMaterializer = this.createRelationalExprMaterializer();
        ETRelationalExpr eTRelationalExpr = aEValueSubQuery.getQueryExpression().acceptVisitor(eTRelationalExprMaterializer);
        return new ETValueSubQuery(eTRelationalExpr, aEValueSubQuery.getColumn(), aEValueSubQuery.isCorrelated());
    }

    protected ETRelationalExprMaterializer createRelationalExprMaterializer() {
        return new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
    }

    private ETConstant doLiteralConversion(AELiteral aELiteral, ConversionResult conversionResult) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = aELiteral.createDataWrapper(conversionResult);
        return new ETConstant(iSqlDataWrapper);
    }

    private ETValueExpr materializeAggregateFn(AEAggrFn aEAggrFn) throws ErrorException {
        IAggregatorFactory iAggregatorFactory = ETAggregateFnFactory.makeNewAggregatorFactory(aEAggrFn, this.getContext().getExternalAlgorithmProperties().getCellMemoryLimit());
        ETValueExprList eTValueExprList = new ETValueExprList();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        Iterator<AEValueExpr> iterator = aEAggrFn.getChildItr();
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = iterator.next();
            eTValueExprList.addNode((IETNode)aEValueExpr.acceptVisitor(this));
            arrayList.add(aEValueExpr.getColumn());
        }
        if (AEAggrFn.AggrFnQuantifier.DISTINCT == aEAggrFn.getSetQuantifier()) {
            return new ETDistinctAggregateFn(aEAggrFn.getAggrFnId(), eTValueExprList, arrayList, iAggregatorFactory.createAggregator(), this.getContext());
        }
        return new ETAggregateFn(aEAggrFn.getAggrFnId(), eTValueExprList, arrayList, iAggregatorFactory.createAggregator());
    }

    private ETValueExpr materializeBinArithExpr(AEBinaryValueExpr aEBinaryValueExpr, ArithmeticExprType arithmeticExprType) throws ErrorException {
        AEValueExpr aEValueExpr = aEBinaryValueExpr.getLeftOperand();
        AEValueExpr aEValueExpr2 = aEBinaryValueExpr.getRightOperand();
        IColumn iColumn = aEValueExpr.getColumn();
        IColumn iColumn2 = aEValueExpr2.getColumn();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
        ETValueExpr eTValueExpr2 = aEValueExpr2.acceptVisitor(this);
        BinaryArithmeticOperator binaryArithmeticOperator = ArithmeticFunctorFactory.getBinaryArithFunctor(arithmeticExprType, aEBinaryValueExpr.getColumn(), iColumn, iColumn2);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, iColumn, binaryArithmeticOperator.getLeftMetadata(), this.getContext());
        eTValueExpr2 = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr2, iColumn2, binaryArithmeticOperator.getRightMetadata(), this.getContext());
        return new ETBinaryArithValueExpr(binaryArithmeticOperator.getLeftMetadata(), eTValueExpr, binaryArithmeticOperator.getRightMetadata(), eTValueExpr2, binaryArithmeticOperator.getFunctor());
    }

    private ETValueExpr materializeUnaryArithExpr(AEUnaryValueExpr aEUnaryValueExpr, ArithmeticExprType arithmeticExprType) throws ErrorException {
        AEValueExpr aEValueExpr = aEUnaryValueExpr.getOperand();
        IColumn iColumn = aEValueExpr.getColumn();
        IColumn iColumn2 = aEUnaryValueExpr.getColumn();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(this);
        eTValueExpr = ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, iColumn, iColumn2, this.getContext());
        IUnaryArithmeticFunctor iUnaryArithmeticFunctor = ArithmeticFunctorFactory.getUnaryArithFunctor(arithmeticExprType, aEUnaryValueExpr.getTypeMetadata(), iColumn.getTypeMetadata());
        return new ETUnaryArithValueExpr(iColumn, eTValueExpr, iUnaryArithmeticFunctor);
    }
}

