/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.support;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomClassLoader
extends URLClassLoader {
    private static final String FILE_PROTOCOL = "file://localhost/";
    private static final String JAR_PROTOCOL;
    private static final String JAR_END = "!/";
    private static final Method getClassLoadingLock;

    public CustomClassLoader(String string) throws MalformedURLException {
        super(CustomClassLoader.getURLArray(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        CustomClassLoader customClassLoader;
        try {
            customClassLoader = getClassLoadingLock == null ? this : getClassLoadingLock.invoke((Object)this, string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        CustomClassLoader customClassLoader2 = customClassLoader;
        synchronized (customClassLoader2) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassLoader classLoader = this.getParent();
                    clazz = classLoader == null ? CustomClassLoader.getSystemClassLoader().loadClass(string) : classLoader.loadClass(string);
                }
            }
            return clazz;
        }
    }

    @Override
    public URL getResource(String string) {
        URL uRL = this.findResource(string);
        if (null == uRL) {
            ClassLoader classLoader = this.getParent();
            uRL = classLoader != null ? classLoader.getResource(string) : CustomClassLoader.getSystemClassLoader().getResource(string);
        }
        return uRL;
    }

    private static URL[] getURLArray(String string) throws MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = string.split(";");
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(stringArray[i]).exists()) continue;
            File file = new File(stringArray[i]);
            if (file.isDirectory()) {
                stringBuilder.append(FILE_PROTOCOL + stringArray[i]);
                if (!stringArray[i].endsWith("/")) {
                    stringBuilder.append("/");
                }
            } else if (file.isFile()) {
                stringBuilder.append(JAR_PROTOCOL + stringArray[i] + JAR_END);
            }
            try {
                uRLArray[i] = new URL(stringBuilder.toString());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new MalformedURLException("Malformed URL: " + stringArray[i]);
            }
        }
        return uRLArray;
    }

    static {
        Method method;
        JAR_PROTOCOL = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "jar:file:/" : "jar:file:";
        try {
            method = ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        getClassLoadingLock = method;
    }
}

