/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ds.common;

import com.kingbase8.Driver;
import com.kingbase8.KBProperty;
import com.kingbase8.ds.common.KBObjectFactory;
import com.kingbase8.jdbc.AutoSave;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.util.ExpressionProperties;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class BaseDataSource
implements CommonDataSource,
Referenceable {
    private String serverName = "localhost";
    private String databaseName = "";
    private String user;
    private String password;
    private int portNumber = 0;
    private Properties properties = new Properties();

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), user, password);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Created a {0} for {1} at {2}", new Object[]{this.getDescription(), user, this.getUrl()});
            }
            return con;
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Failed to create a {0} for {1} at {2}: {3}", new Object[]{this.getDescription(), user, this.getUrl(), e});
            throw e;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName == null || serverName.equals("") ? "localhost" : serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public int getLoginTimeout() {
        return KBProperty.LOGIN_TIMEOUT.getIntNoCheck(this.properties);
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        KBProperty.LOGIN_TIMEOUT.set(this.properties, loginTimeout);
    }

    public int getConnectTimeout() {
        return KBProperty.CONNECT_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setConnectTimeout(int connectTimeout) {
        KBProperty.CONNECT_TIMEOUT.set(this.properties, connectTimeout);
    }

    public int getProtocolVersion() {
        if (!KBProperty.PROTOCOL_VERSION.isPresent(this.properties)) {
            return 0;
        }
        return KBProperty.PROTOCOL_VERSION.getIntNoCheck(this.properties);
    }

    public void setProtocolVersion(int protocolVersion) {
        if (protocolVersion == 0) {
            KBProperty.PROTOCOL_VERSION.set(this.properties, null);
        } else {
            KBProperty.PROTOCOL_VERSION.set(this.properties, protocolVersion);
        }
    }

    public int getReceiveBufferSize() {
        return KBProperty.RECEIVE_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setReceiveBufferSize(int nbytes) {
        KBProperty.RECEIVE_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public int getSendBufferSize() {
        return KBProperty.SEND_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setSendBufferSize(int nbytes) {
        KBProperty.SEND_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public void setPrepareThreshold(int count) {
        KBProperty.PREPARE_THRESHOLD.set(this.properties, count);
    }

    public int getPrepareThreshold() {
        return KBProperty.PREPARE_THRESHOLD.getIntNoCheck(this.properties);
    }

    public int getPreparedStatementCacheQueries() {
        return KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheQueries(int cacheSize) {
        KBProperty.PREPARED_STATEMENT_CACHE_QUERIES.set(this.properties, cacheSize);
    }

    public int getPreparedStatementCacheSizeMiB() {
        return KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheSizeMiB(int cacheSize) {
        KBProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFields() {
        return KBProperty.DATABASE_METADATA_CACHE_FIELDS.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFields(int cacheSize) {
        KBProperty.DATABASE_METADATA_CACHE_FIELDS.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFieldsMiB() {
        return KBProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFieldsMiB(int cacheSize) {
        KBProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.set(this.properties, cacheSize);
    }

    public void setDefaultRowFetchSize(int fetchSize) {
        KBProperty.DEFAULT_ROW_FETCH_SIZE.set(this.properties, fetchSize);
    }

    public int getDefaultRowFetchSize() {
        return KBProperty.DEFAULT_ROW_FETCH_SIZE.getIntNoCheck(this.properties);
    }

    public void setUnknownLength(int unknownLength) {
        KBProperty.UNKNOWN_LENGTH.set(this.properties, unknownLength);
    }

    public int getUnknownLength() {
        return KBProperty.UNKNOWN_LENGTH.getIntNoCheck(this.properties);
    }

    public void setSocketTimeout(int seconds) {
        KBProperty.SOCKET_TIMEOUT.set(this.properties, seconds);
    }

    public int getSocketTimeout() {
        return KBProperty.SOCKET_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setCancelSignalTimeout(int seconds) {
        KBProperty.CANCEL_SIGNAL_TIMEOUT.set(this.properties, seconds);
    }

    public int getCancelSignalTimeout() {
        return KBProperty.CANCEL_SIGNAL_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setSsl(boolean enabled) {
        if (enabled) {
            KBProperty.SSL.set(this.properties, true);
        } else {
            KBProperty.SSL.set(this.properties, false);
        }
    }

    public boolean getSsl() {
        return KBProperty.SSL.getBoolean(this.properties) || "".equals(KBProperty.SSL.get(this.properties));
    }

    public void setSslfactory(String classname) {
        KBProperty.SSL_FACTORY.set(this.properties, classname);
    }

    public String getSslfactory() {
        return KBProperty.SSL_FACTORY.get(this.properties);
    }

    public String getSslMode() {
        return KBProperty.SSL_MODE.get(this.properties);
    }

    public void setSslMode(String mode) {
        KBProperty.SSL_MODE.set(this.properties, mode);
    }

    public String getSslFactoryArg() {
        return KBProperty.SSL_FACTORY_ARG.get(this.properties);
    }

    public void setSslFactoryArg(String arg) {
        KBProperty.SSL_FACTORY_ARG.set(this.properties, arg);
    }

    public String getSslHostnameVerifier() {
        return KBProperty.SSL_HOSTNAME_VERIFIER.get(this.properties);
    }

    public void setSslHostnameVerifier(String className) {
        KBProperty.SSL_HOSTNAME_VERIFIER.set(this.properties, className);
    }

    public String getSslCert() {
        return KBProperty.SSL_CERT.get(this.properties);
    }

    public void setSslCert(String file) {
        KBProperty.SSL_CERT.set(this.properties, file);
    }

    public String getSslKey() {
        return KBProperty.SSL_KEY.get(this.properties);
    }

    public void setSslKey(String file) {
        KBProperty.SSL_KEY.set(this.properties, file);
    }

    public String getSslRootCert() {
        return KBProperty.SSL_ROOT_CERT.get(this.properties);
    }

    public void setSslRootCert(String file) {
        KBProperty.SSL_ROOT_CERT.set(this.properties, file);
    }

    public String getSslPassword() {
        return KBProperty.SSL_PASSWORD.get(this.properties);
    }

    public void setSslPassword(String password) {
        KBProperty.SSL_PASSWORD.set(this.properties, password);
    }

    public String getSslPasswordCallback() {
        return KBProperty.SSL_PASSWORD_CALLBACK.get(this.properties);
    }

    public void setSslPasswordCallback(String className) {
        KBProperty.SSL_PASSWORD_CALLBACK.set(this.properties, className);
    }

    public void setApplicationName(String applicationName) {
        KBProperty.APPLICATION_NAME.set(this.properties, applicationName);
    }

    public String getApplicationName() {
        return KBProperty.APPLICATION_NAME.get(this.properties);
    }

    public void setTargetServerType(String targetServerType) {
        KBProperty.TARGET_SERVER_TYPE.set(this.properties, targetServerType);
    }

    public String getTargetServerType() {
        return KBProperty.TARGET_SERVER_TYPE.get(this.properties);
    }

    public void setLoadBalanceHosts(boolean loadBalanceHosts) {
        KBProperty.LOAD_BALANCE_HOSTS.set(this.properties, loadBalanceHosts);
    }

    public boolean getLoadBalanceHosts() {
        return KBProperty.LOAD_BALANCE_HOSTS.isPresent(this.properties);
    }

    public void setHostRecheckSeconds(int hostRecheckSeconds) {
        KBProperty.HOST_RECHECK_SECONDS.set(this.properties, hostRecheckSeconds);
    }

    public int getHostRecheckSeconds() {
        return KBProperty.HOST_RECHECK_SECONDS.getIntNoCheck(this.properties);
    }

    public void setTcpKeepAlive(boolean enabled) {
        KBProperty.TCP_KEEP_ALIVE.set(this.properties, enabled);
    }

    public boolean getTcpKeepAlive() {
        return KBProperty.TCP_KEEP_ALIVE.getBoolean(this.properties);
    }

    public void setBinaryTransfer(boolean enabled) {
        KBProperty.BINARY_TRANSFER.set(this.properties, enabled);
    }

    public boolean getBinaryTransfer() {
        return KBProperty.BINARY_TRANSFER.getBoolean(this.properties);
    }

    public void setBinaryTransferEnable(String oidList) {
        KBProperty.BINARY_TRANSFER_ENABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferEnable() {
        return KBProperty.BINARY_TRANSFER_ENABLE.get(this.properties);
    }

    public void setBinaryTransferDisable(String oidList) {
        KBProperty.BINARY_TRANSFER_DISABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferDisable() {
        return KBProperty.BINARY_TRANSFER_DISABLE.get(this.properties);
    }

    public String getStringType() {
        return KBProperty.STRING_TYPE.get(this.properties);
    }

    public void setStringType(String stringType) {
        KBProperty.STRING_TYPE.set(this.properties, stringType);
    }

    public boolean isColumnSanitiserDisabled() {
        return KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public boolean getDisableColumnSanitiser() {
        return KBProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        KBProperty.DISABLE_COLUMN_SANITISER.set(this.properties, disableColumnSanitiser);
    }

    public String getCurrentSchema() {
        return KBProperty.CURRENT_SCHEMA.get(this.properties);
    }

    public void setCurrentSchema(String currentSchema) {
        KBProperty.CURRENT_SCHEMA.set(this.properties, currentSchema);
    }

    public boolean getReadOnly() {
        return KBProperty.READ_ONLY.getBoolean(this.properties);
    }

    public void setReadOnly(boolean readOnly) {
        KBProperty.READ_ONLY.set(this.properties, readOnly);
    }

    public boolean getLogUnclosedConnections() {
        return KBProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(this.properties);
    }

    public void setLogUnclosedConnections(boolean enabled) {
        KBProperty.LOG_UNCLOSED_CONNECTIONS.set(this.properties, enabled);
    }

    public String getAssumeMinServerVersion() {
        return KBProperty.ASSUME_MIN_SERVER_VERSION.get(this.properties);
    }

    public void setAssumeMinServerVersion(String minVersion) {
        KBProperty.ASSUME_MIN_SERVER_VERSION.set(this.properties, minVersion);
    }

    public String getJaasApplicationName() {
        return KBProperty.JAAS_APPLICATION_NAME.get(this.properties);
    }

    public void setJaasApplicationName(String name) {
        KBProperty.JAAS_APPLICATION_NAME.set(this.properties, name);
    }

    public String getKerberosServerName() {
        return KBProperty.KERBEROS_SERVER_NAME.get(this.properties);
    }

    public void setKerberosServerName(String serverName) {
        KBProperty.KERBEROS_SERVER_NAME.set(this.properties, serverName);
    }

    public boolean getUseSpNego() {
        return KBProperty.USE_SPNEGO.getBoolean(this.properties);
    }

    public void setUseSpNego(boolean use) {
        KBProperty.USE_SPNEGO.set(this.properties, use);
    }

    public String getGssLib() {
        return KBProperty.GSS_LIB.get(this.properties);
    }

    public void setGssLib(String lib) {
        KBProperty.GSS_LIB.set(this.properties, lib);
    }

    public String getSspiServiceClass() {
        return KBProperty.SSPI_SERVICE_CLASS.get(this.properties);
    }

    public void setSspiServiceClass(String serviceClass) {
        KBProperty.SSPI_SERVICE_CLASS.set(this.properties, serviceClass);
    }

    public boolean getAllowEncodingChanges() {
        return KBProperty.ALLOW_ENCODING_CHANGES.getBoolean(this.properties);
    }

    public void setAllowEncodingChanges(boolean allow) {
        KBProperty.ALLOW_ENCODING_CHANGES.set(this.properties, allow);
    }

    public String getSocketFactory() {
        return KBProperty.SOCKET_FACTORY.get(this.properties);
    }

    public void setSocketFactory(String socketFactoryClassName) {
        KBProperty.SOCKET_FACTORY.set(this.properties, socketFactoryClassName);
    }

    public String getSocketFactoryArg() {
        return KBProperty.SOCKET_FACTORY_ARG.get(this.properties);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        KBProperty.SOCKET_FACTORY_ARG.set(this.properties, socketFactoryArg);
    }

    public void setReplication(String replication) {
        KBProperty.REPLICATION.set(this.properties, replication);
    }

    public String getReplication() {
        return KBProperty.REPLICATION.get(this.properties);
    }

    public String getLoggerLevel() {
        return KBProperty.LOGGER_LEVEL.get(this.properties);
    }

    public void setLoggerLevel(String loggerLevel) {
        KBProperty.LOGGER_LEVEL.set(this.properties, loggerLevel);
    }

    public String getLoggerFile() {
        ExpressionProperties exprProps = new ExpressionProperties(this.properties, System.getProperties());
        return KBProperty.LOGGER_FILE.get(exprProps);
    }

    public void setLoggerFile(String loggerFile) {
        KBProperty.LOGGER_FILE.set(this.properties, loggerFile);
    }

    public String getUrl() {
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:kingbase8://");
        url.append(this.serverName);
        if (this.portNumber != 0) {
            url.append(":").append(this.portNumber);
        }
        url.append("/").append(this.databaseName);
        StringBuilder query = new StringBuilder(100);
        for (KBProperty property : KBProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            if (query.length() != 0) {
                query.append("&");
            }
            query.append(property.getName());
            query.append("=");
            query.append(property.get(this.properties));
        }
        if (query.length() > 0) {
            url.append("?");
            url.append((CharSequence)query);
        }
        return url.toString();
    }

    public void setUrl(String url) {
        Properties p = Driver.parseURL(url, null);
        for (KBProperty property : KBProperty.values()) {
            this.setProperty(property, property.get(p));
        }
    }

    public String getProperty(String name) throws SQLException {
        KBProperty pgProperty = KBProperty.forName(name);
        if (pgProperty != null) {
            return this.getProperty(pgProperty);
        }
        throw new KSQLException(GT.tr("Unsupported property name: {0}", name), KSQLState.INVALID_PARAMETER_VALUE);
    }

    public void setProperty(String name, String value) throws SQLException {
        KBProperty pgProperty = KBProperty.forName(name);
        if (pgProperty == null) {
            throw new KSQLException(GT.tr("Unsupported property name: {0}", name), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setProperty(pgProperty, value);
    }

    public String getProperty(KBProperty property) {
        return property.get(this.properties);
    }

    public void setProperty(KBProperty property, String value) {
        if (value == null) {
            return;
        }
        switch (property) {
            case KB_HOST: {
                this.serverName = value;
                break;
            }
            case KB_PORT: {
                try {
                    this.portNumber = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.portNumber = 0;
                }
                break;
            }
            case KB_DBNAME: {
                this.databaseName = value;
                break;
            }
            case USER: {
                this.user = value;
                break;
            }
            case PASSWORD: {
                this.password = value;
                break;
            }
            default: {
                this.properties.setProperty(property.getName(), value);
            }
        }
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), KBObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        ref.add(new StringRefAddr("serverName", this.serverName));
        if (this.portNumber != 0) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        for (KBProperty property : KBProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            ref.add(new StringRefAddr(property.getName(), property.get(this.properties)));
        }
        return ref;
    }

    public void setFromReference(Reference ref) {
        this.databaseName = BaseDataSource.getReferenceProperty(ref, "databaseName");
        String port = BaseDataSource.getReferenceProperty(ref, "portNumber");
        if (port != null) {
            this.portNumber = Integer.parseInt(port);
        }
        this.serverName = BaseDataSource.getReferenceProperty(ref, "serverName");
        this.user = BaseDataSource.getReferenceProperty(ref, "user");
        this.password = BaseDataSource.getReferenceProperty(ref, "password");
        for (KBProperty property : KBProperty.values()) {
            property.set(this.properties, BaseDataSource.getReferenceProperty(ref, property.getName()));
        }
    }

    private static String getReferenceProperty(Reference ref, String propertyName) {
        RefAddr addr = ref.get(propertyName);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    protected void writeBaseObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.serverName);
        out.writeObject(this.databaseName);
        out.writeObject(this.user);
        out.writeObject(this.password);
        out.writeInt(this.portNumber);
        out.writeObject(this.properties);
    }

    protected void readBaseObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serverName = (String)in.readObject();
        this.databaseName = (String)in.readObject();
        this.user = (String)in.readObject();
        this.password = (String)in.readObject();
        this.portNumber = in.readInt();
        this.properties = (Properties)in.readObject();
    }

    public void initializeFrom(BaseDataSource source) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        source.writeBaseObject(oos);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.readBaseObject(ois);
    }

    public PreferQueryMode getPreferQueryMode() {
        return PreferQueryMode.of(KBProperty.PREFER_QUERY_MODE.get(this.properties));
    }

    public void setPreferQueryMode(PreferQueryMode preferQueryMode) {
        KBProperty.PREFER_QUERY_MODE.set(this.properties, preferQueryMode.value());
    }

    public AutoSave getAutosave() {
        return AutoSave.of(KBProperty.AUTOSAVE.get(this.properties));
    }

    public void setAutosave(AutoSave autoSave) {
        KBProperty.AUTOSAVE.set(this.properties, autoSave.value());
    }

    public boolean getReWriteBatchedInserts() {
        return KBProperty.REWRITE_BATCHED_INSERTS.getBoolean(this.properties);
    }

    public void setReWriteBatchedInserts(boolean reWrite) {
        KBProperty.REWRITE_BATCHED_INSERTS.set(this.properties, reWrite);
    }

    public String getclientEncoding() {
        return KBProperty.CLIENT_ENCODING.get(this.properties);
    }

    public void setclientEncoding(String clientencoding) {
        KBProperty.CLIENT_ENCODING.set(this.properties, clientencoding);
    }

    public boolean getUseDispatch() {
        return KBProperty.USEDISPATCH.getBoolean(this.properties);
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("com.kingbase8");
    }

    public void setUseDispatch(boolean useDispatch) {
        KBProperty.USEDISPATCH.set(this.properties, useDispatch);
    }

    public int getHostLoadRate() {
        return KBProperty.HOSTLOADRATE.getIntNoCheck(this.properties);
    }

    public void setHostLoadRate(int hostLoadRate) {
        KBProperty.HOSTLOADRATE.set(this.properties, hostLoadRate);
    }

    public String getSlave_Add() {
        return KBProperty.SLAVE_ADD.get(this.properties);
    }

    public void setSlave_Add(String slaveAdd) {
        KBProperty.SLAVE_ADD.set(this.properties, slaveAdd);
    }

    public String getSlave_Port() {
        return KBProperty.SLAVE_PORT.get(this.properties);
    }

    public void setSlave_Port(String slavePort) {
        KBProperty.SLAVE_PORT.set(this.properties, slavePort);
    }

    public boolean getUseconnect_Pool() {
        return KBProperty.USECONNECT_POOL.getBoolean(this.properties);
    }

    public void setUseconnect_Pool(boolean useconnectPool) {
        KBProperty.USECONNECT_POOL.set(this.properties, useconnectPool);
    }

    public int getConnect_PoolSize() {
        return KBProperty.CONNECT_POOLSIZE.getIntNoCheck(this.properties);
    }

    public void setConnect_PoolSize(int connectPoolSize) {
        KBProperty.CONNECT_POOLSIZE.set(this.properties, connectPoolSize);
    }

    public boolean getMaster_Check() {
        return KBProperty.MASTER_CHECK.getBoolean(this.properties);
    }

    public void setMaster_Check(boolean masterCheck) {
        KBProperty.MASTER_CHECK.set(this.properties, masterCheck);
    }

    public boolean getCluster_Monitor() {
        return KBProperty.CLUSTER_MONITOR.getBoolean(this.properties);
    }

    public void setCluster_Monitor(boolean clusterMonitor) {
        KBProperty.CLUSTER_MONITOR.set(this.properties, clusterMonitor);
    }

    public int getMonitorInterval() {
        return KBProperty.MONITORINTERVAL.getIntNoCheck(this.properties);
    }

    public void setMonitorInterval(int monitorInterval) {
        KBProperty.MONITORINTERVAL.set(this.properties, monitorInterval);
    }

    public int getRetryTimes() {
        return KBProperty.RETRYTIMES.getIntNoCheck(this.properties);
    }

    public void setRetryTimes(int retryTimes) {
        KBProperty.RETRYTIMES.set(this.properties, retryTimes);
    }

    public int getRetryInterval() {
        return KBProperty.RETRYINTERVAL.getIntNoCheck(this.properties);
    }

    public void setRetryInterval(int retryInterval) {
        KBProperty.RETRYINTERVAL.set(this.properties, retryInterval);
    }

    public String getClient_Encoding() {
        return KBProperty.CLIENT_ENCODING.get(this.properties);
    }

    public void setClient_Encoding(String clientEncoding) {
        KBProperty.CLIENT_ENCODING.set(this.properties, clientEncoding);
    }

    public String getConfigurePath() {
        return KBProperty.CONFIGUREPATH.get(this.properties);
    }

    public void setConfigurePath(String configurePath) {
        KBProperty.CONFIGUREPATH.set(this.properties, configurePath);
    }

    public String getDBNAME() {
        return KBProperty.KB_DBNAME.get(this.properties);
    }

    public void setDBNAME(String DBNAME) {
        KBProperty.KB_DBNAME.set(this.properties, DBNAME);
    }

    public String getHOST() {
        return KBProperty.KB_HOST.get(this.properties);
    }

    public void setHOST(String HOST) {
        KBProperty.KB_HOST.set(this.properties, HOST);
    }

    public String getPORT() {
        return KBProperty.KB_PORT.get(this.properties);
    }

    public void setPORT(String PORT) {
        KBProperty.KB_PORT.set(this.properties, PORT);
    }

    public String getTransactionDispatchStrategy() {
        return KBProperty.TRANSACTIONDISPATCHSTRATEGY.get(this.properties);
    }

    public void setTransactionDispatchStrategy(String TransactionDispatchStrategy) {
        KBProperty.TRANSACTIONDISPATCHSTRATEGY.set(this.properties, TransactionDispatchStrategy);
    }

    public String getWhiteList() {
        return KBProperty.WHITELIST.get(this.properties);
    }

    public void setWhiteList(String whiteList) {
        KBProperty.WHITELIST.set(this.properties, whiteList);
    }

    public String getPasswordEncryption() {
        return KBProperty.PASSWORD_ENCRYPTION.get(this.properties);
    }

    public void setPasswordEncryption(String passwordEncryption) {
        KBProperty.PASSWORD_ENCRYPTION.set(this.properties, passwordEncryption);
    }

    public String getBlackList() {
        return KBProperty.BLACKLIST.get(this.properties);
    }

    public void setBlackList(String whiteList) {
        KBProperty.BLACKLIST.set(this.properties, whiteList);
    }

    public String getMasterFunctionList() {
        return KBProperty.MASTERFUNCTIONLIST.get(this.properties);
    }

    public void setMasterFunctionList(String whiteList) {
        KBProperty.MASTERFUNCTIONLIST.set(this.properties, whiteList);
    }

    public String getTempTable() {
        return KBProperty.TEMPTABLE.get(this.properties);
    }

    public void setTempTable(String whiteList) {
        KBProperty.TEMPTABLE.set(this.properties, whiteList);
    }

    public String getBlackSqlList() {
        return KBProperty.BLACKSQLLIST.get(this.properties);
    }

    public void setBlackSqlList(String whiteList) {
        KBProperty.BLACKSQLLIST.set(this.properties, whiteList);
    }

    static {
        try {
            Class.forName("com.kingbase8.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("BaseDataSource is unable to load com.kingbase8.Driver. Please check if you have proper Kingbase8 JDBC Driver jar on the classpath", e);
        }
    }
}

