/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.v3.BatchedQuery;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.KbArray;
import com.kingbase8.jdbc.KbBlob;
import com.kingbase8.jdbc.KbClob;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbParameterMetaData;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbSQLXML;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.ResultWrapper;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.HStoreConverter;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBTime;
import com.kingbase8.util.KBTimestamp;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;

public class KbPreparedStatement
extends KbStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected ParameterList preparedParameters;
    protected boolean adjustIndex = false;
    protected boolean outParmBeforeFunc = false;
    private TimeZone defaultTimeZone;
    protected ParameterMetaData prepmd = null;

    KbPreparedStatement(KbConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this(connection, connection.borrowQuery(sql), rsType, rsConcurrency, rsHoldability);
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, sql);
        }
    }

    KbPreparedStatement(KbConnection connection, CachedQuery query, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.preparedQuery = query;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        this.setPoolable(true);
        this.prepmd = null;
    }

    public void copyPreparedStatementInfo(KbPreparedStatement stnew) {
        this.preparedParameters = stnew.preparedParameters;
        this.adjustIndex = stnew.adjustIndex;
        this.outParmBeforeFunc = stnew.outParmBeforeFunc;
        this.defaultTimeZone = stnew.defaultTimeZone;
        this.prepmd = stnew.prepmd;
    }

    public ParameterList getPreParmlist() {
        return this.preparedParameters;
    }

    public void setPreParmlist(ParameterList preParm) {
        this.preparedParameters = preParm;
    }

    @Override
    public ResultSet executeQuery(String p_sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new KSQLException(GT.tr("Multiple ResultSets were returned by the query.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    @Override
    public int executeUpdate(String p_sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeWithFlags(4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new KSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String p_sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                flags |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameters, flags);
            boolean bl = this.result != null && this.result.getResultSet() != null;
            return bl;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(cachedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.preparedQuery != null) {
            CachedQuery cachedQuery = this.preparedQuery;
            synchronized (cachedQuery) {
                if (!this.isClosed) {
                    ((KbConnection)this.connection).releaseQuery(this.preparedQuery);
                }
            }
        }
        super.close();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, sqlType: {1}", new Object[]{parameterIndex, sqlType});
        }
        switch (sqlType) {
            case 2009: {
                oid = 142;
                break;
            }
            case 4: {
                oid = 23;
                break;
            }
            case -6: {
                oid = 9;
                break;
            }
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                oid = 0;
                break;
            }
            case -7: 
            case 16: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                oid = 0;
                break;
            }
            case 2004: {
                oid = 11659;
                break;
            }
            case 2005: {
                oid = 11658;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new KSQLException(GT.tr("Unknown Types value.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        this.bindLiteral(parameterIndex, x ? "1" : "0", 0);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (this.connection.binaryTransferSend(9)) {
            byte[] val = new byte[1];
            ByteConverter.int1(val, 0, x);
            this.bindBytes(parameterIndex, val, 9);
            return;
        }
        this.bindLiteral(parameterIndex, Byte.toString(x), 9);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, Float.valueOf(x)});
        }
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}", new Object[]{parameterIndex});
        }
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, oid: {1}", new Object[]{parameterIndex, oid});
        }
        if (x == null) {
            if (this.adjustIndex) {
                --parameterIndex;
            }
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}, encoding: {3}", new Object[]{parameterIndex, x, length, encoding});
        }
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader l_inStream = new InputStreamReader(x, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), 1043);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new KSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), KSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
        }
        catch (IOException l_ioe) {
            throw new KSQLException(GT.tr("Provided InputStream failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)l_ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{parameterIndex, x, length});
        }
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{parameterIndex, x, length});
        }
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{parameterIndex, x, length});
        }
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private void setKBobject(int parameterIndex, KBobject x) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof KBBinaryObject && this.connection.binaryTransferSend(oid)) {
            KBBinaryObject binObj = (KBBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        int oid;
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if ((oid = this.connection.getTypeInfo().getKBType("HSTORE")) == 0) {
            throw new KSQLException(GT.tr("No hstore extension installed.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, targetSqlType: {2}, scale: {3}", new Object[]{parameterIndex, in, targetSqlType, scale});
        }
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        if (targetSqlType == 1111 && in instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)in);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, new KbSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, KbPreparedStatement.castToInt(in));
                break;
            }
            case -6: {
                this.setByte(parameterIndex, KbPreparedStatement.castToByte(in));
                break;
            }
            case 5: {
                this.setShort(parameterIndex, KbPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, KbPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, KbPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, KbPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, KbPreparedStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), 1042);
                break;
            }
            case 12: {
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case -1: {
                if (in instanceof InputStream) {
                    this.preparedParameters.setText(parameterIndex, (InputStream)in);
                    break;
                }
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                Date tmpd;
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpd = new Date(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDate) {
                        this.setDate(parameterIndex, (LocalDate)in);
                        break;
                    }
                    tmpd = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), in.toString());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpt = new Time(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalTime) {
                        this.setTime(parameterIndex, (LocalTime)in);
                        break;
                    }
                    tmpt = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                if (in instanceof KBTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpts = new Timestamp(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDateTime) {
                        this.setTimestamp(parameterIndex, (LocalDateTime)in);
                        break;
                    }
                    tmpts = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), in.toString());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case 2014: {
                if (in instanceof OffsetDateTime) {
                    this.setTimestamp(parameterIndex, (OffsetDateTime)in);
                    break;
                }
                if (in instanceof KBTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 16: {
                this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in));
                break;
            }
            case -7: {
                if (in instanceof Boolean) {
                    this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in));
                    break;
                }
                if (in instanceof byte[] || in instanceof char[]) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Byte) {
                    this.setByte(parameterIndex, (Byte)in);
                    break;
                }
                this.setString(parameterIndex, in.toString(), 0);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    Blob lo = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setBlob(parameterIndex, lo);
                    break;
                }
                if (in instanceof byte[]) {
                    this.setBytes(parameterIndex, (byte[])in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                if (in instanceof String) {
                    this.setString(parameterIndex, (String)in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.CLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.ARRAY"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof KBobject) {
                    this.setKBobject(parameterIndex, (KBobject)in);
                    break;
                }
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new KSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "INT", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "INT");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static byte castToByte(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Byte.parseByte((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).byteValue();
            }
            if (in instanceof java.util.Date) {
                return (byte)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (byte)1 : 0;
            }
            if (in instanceof Clob) {
                return Byte.parseByte(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Byte.parseByte(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "byte", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "byte");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "FLOAT", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "FLOAT");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof java.util.Date) {
                rc = BigDecimal.valueOf(((java.util.Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(KbPreparedStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return KbPreparedStatement.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    private static KSQLException cannotCastException(String fromType, String toType) {
        return KbPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static KSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new KSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), KSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, targetSqlType: {2}", new Object[]{parameterIndex, x, targetSqlType});
        }
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, x});
        }
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x, 0);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof KBobject) {
            this.setKBobject(parameterIndex, (KBobject)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else {
            this.setString(parameterIndex, x.toString(), 0);
        }
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.m_prepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.m_prepareThreshold;
    }

    @Override
    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "addBatch-query:{0}", query.getNativeSql());
        }
        if (!(query instanceof BatchedQuery) || this.batchStatements.isEmpty()) {
            this.batchStatements.add(query);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((KbResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            KbStatement.StatementResultHandler handler = new KbStatement.StatementResultHandler(this);
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        KbArray arr;
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{i, x});
        }
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName() + "[]";
        int oid = this.connection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof KbArray && (arr = (KbArray)x).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected Blob createBlob(int i, InputStream inputStream, long length) throws SQLException {
        KbBlob lob = new KbBlob(new byte[0]);
        byte[] buf = new byte[4096];
        try {
            int pos = 1;
            long remaining = length > 0L ? length : Integer.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                lob.setBytes(pos, buf, 0, numRead);
                pos += numRead - 1;
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new KSQLException(GT.tr("Unexpected error writing blob object.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        return lob;
    }

    protected Clob createClob(int i, Reader reader, long length) throws SQLException {
        KbClob lob = new KbClob(new char[0], this.connection.getEncoding().name());
        char[] buf = new char[4096];
        try {
            int pos = 1;
            long remaining = length > 0L ? length : Integer.MAX_VALUE;
            int numRead = reader.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                lob.setString(pos, String.valueOf(buf).trim(), 0, String.valueOf(buf).trim().length());
                pos += numRead - 1;
                numRead = reader.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new KSQLException(GT.tr("Unexpected error writing clob object.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        return lob;
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{i, x});
        }
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        this.setBinaryStream(i, x.getBinaryStream());
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("Provided Reader failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{i, x, length});
        }
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{i, x});
        }
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        this.setCharacterStream(i, x.getCharacterStream());
    }

    @Override
    public void setNull(int i, int t, String s) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, t: {1}, s: {2}", new Object[]{i, t, s});
        }
        this.setNull(i, t);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{i, x});
        }
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, d: {1}, cal: {2}", new Object[]{i, d, cal});
        }
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, t: {1}, cal: {2}", new Object[]{i, t, cal});
        }
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 0;
        if (t instanceof KBTime) {
            KBTime pgTime = (KBTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, t: {1}, cal: {2}", new Object[]{i, t, cal});
        }
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 0;
        if (t instanceof KBTimestamp) {
            KBTimestamp pgTimestamp = (KBTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, localDate: {1}", new Object[]{i, localDate});
        }
        int oid = 1082;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDate), oid);
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, localTime: {1}", new Object[]{i, localTime});
        }
        int oid = 1083;
        this.bindString(i, this.connection.getTimestampUtils().toString(localTime), oid);
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, localDateTime: {1}", new Object[]{i, localDateTime});
        }
        int oid = 1114;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDateTime), oid);
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, offsetDateTime: {1}", new Object[]{i, offsetDateTime});
        }
        int oid = 1184;
        this.bindString(i, this.connection.getTimestampUtils().toString(offsetDateTime), oid);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new KbParameterMetaData(conn, oids);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, value});
        }
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
            this.setString(parameterIndex, s);
            return;
        }
        ReaderInputStream is = value != null ? new ReaderInputStream(value, this.connection.getEncoding().name()) : null;
        this.setObject(parameterIndex, (Object)is, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new KSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{parameterIndex, value, length});
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, value});
        }
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, reader});
        }
        if (reader == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}, length: {2}", new Object[]{parameterIndex, inputStream, length});
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, inputStream});
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, xmlObject});
        }
        if (xmlObject == null || xmlObject.getString() == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, xmlObject.getString(), 142);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "parameterIndex: {0}, parameter: {1}", new Object[]{parameterIndex, uuid});
        }
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.batchParameters != null && this.batchParameters.size() > 1 && this.m_prepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.m_prepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        KbStatement.StatementResultHandler handler = new KbStatement.StatementResultHandler(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        if (this.batchParameters.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQuery = (BatchedQuery)this.preparedQuery.query;
        int bindCount = originalQuery.getBindCount();
        int highestBlockCount = 128;
        int maxValueBlocks = bindCount == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / bindCount), 128));
        int unprocessedBatchCount = this.batchParameters.size();
        int fullValueBlocksCount = unprocessedBatchCount / maxValueBlocks;
        int partialValueBlocksCount = Integer.bitCount(unprocessedBatchCount % maxValueBlocks);
        int count = fullValueBlocksCount + partialValueBlocksCount;
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(count);
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(count);
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            int valueBlock = unprocessedBatchCount >= maxValueBlocks ? maxValueBlocks : Integer.highestOneBit(unprocessedBatchCount);
            BatchedQuery bq = originalQuery.deriveForMultiBatch(valueBlock);
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < valueBlock; ++j) {
                ParameterList pl = (ParameterList)this.batchParameters.get(offset++);
                newPl.appendAll(pl);
            }
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCount -= valueBlock;
        }
        this.batchStatements = newBatchStatements;
        this.batchParameters = newBatchParameters;
    }
}

