/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.BaseStatement;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.Field;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.ResultCursor;
import com.kingbase8.core.ResultHandlerBase;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.jdbc.BatchResultHandler;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.ResultWrapper;
import com.kingbase8.jdbc.StatementCancelState;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class KbStatement
implements Statement,
BaseStatement {
    private static final String[] NO_RETURNING_COLUMNS = new String[0];
    private static final boolean DEFAULT_FORCE_BINARY_TRANSFERS = Boolean.getBoolean("com.kingbase8.forceBinary");
    private boolean forceBinaryTransfers = DEFAULT_FORCE_BINARY_TRANSFERS;
    protected ArrayList<Query> batchStatements = null;
    protected ArrayList<ParameterList> batchParameters = null;
    protected int resultsettype;
    protected int concurrency;
    private int rsHoldability;
    private boolean poolable;
    private boolean closeOnCompletion = false;
    protected int fetchdirection = 1000;
    private volatile TimerTask cancelTimerTask = null;
    private static final AtomicReferenceFieldUpdater<KbStatement, TimerTask> CANCEL_TIMER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(KbStatement.class, TimerTask.class, "cancelTimerTask");
    private volatile StatementCancelState statementState = StatementCancelState.IDLE;
    private static final AtomicReferenceFieldUpdater<KbStatement, StatementCancelState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(KbStatement.class, StatementCancelState.class, "statementState");
    protected boolean wantsGeneratedKeysOnce = false;
    public boolean wantsGeneratedKeysAlways = false;
    protected final BaseConnection connection;
    protected SQLWarning warnings = null;
    protected SQLWarning lastWarning = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected ResultWrapper result = null;
    protected ResultWrapper firstUnclosedResult = null;
    protected ResultWrapper generatedKeys = null;
    protected int m_prepareThreshold;
    protected int maxfieldSize = 0;
    Query queryToExecute;
    protected boolean isClosed = false;
    static int i = 0;

    KbStatement(KbConnection c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.connection = c;
        this.forceBinaryTransfers |= c.getForceBinary();
        this.resultsettype = rsType;
        this.concurrency = rsConcurrency;
        this.setFetchSize(c.getDefaultFetchSize());
        this.setPrepareThreshold(c.getPrepareThreshold());
        this.rsHoldability = rsHoldability;
    }

    public void copyStatementInfo(KbStatement stnew) {
        this.batchStatements = stnew.batchStatements;
        this.batchParameters = stnew.batchParameters;
        this.resultsettype = stnew.resultsettype;
        this.concurrency = stnew.concurrency;
        this.rsHoldability = stnew.rsHoldability;
        this.poolable = stnew.poolable;
        this.closeOnCompletion = stnew.closeOnCompletion;
        this.wantsGeneratedKeysOnce = stnew.wantsGeneratedKeysOnce;
        this.wantsGeneratedKeysAlways = stnew.wantsGeneratedKeysAlways;
        this.fetchSize = stnew.fetchSize;
        this.timeout = stnew.timeout;
        this.replaceProcessingEnabled = stnew.replaceProcessingEnabled;
    }

    @Override
    public ResultSet createResultSet(Query originalQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) throws SQLException {
        KbResultSet newResult = new KbResultSet(originalQuery, this, fields, tuples, cursor, this.getMaxRows(), this.getMaxFieldSize(), this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        newResult.setFetchSize(this.getFetchSize());
        newResult.setFetchDirection(this.getFetchDirection());
        return newResult;
    }

    public BaseConnection getKBConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return null;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    protected boolean wantsScrollableResultSet() {
        return this.resultsettype != 1003;
    }

    protected boolean wantsHoldableResultSet() {
        return this.rsHoldability == 1;
    }

    @Override
    public ResultSet executeQuery(String p_sql) throws SQLException {
        if (!this.executeWithFlags(p_sql, 0)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        if (this.result.getNext() != null) {
            throw new KSQLException(GT.tr("Multiple ResultSets were returned by the query.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        return this.result.getResultSet();
    }

    @Override
    public int executeUpdate(String p_sql) throws SQLException {
        this.executeWithFlags(p_sql, 4);
        for (ResultWrapper iter = this.result; iter != null; iter = iter.getNext()) {
            if (iter.getResultSet() == null) continue;
            throw new KSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), KSQLState.TOO_MANY_RESULTS);
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String p_sql) throws SQLException {
        return this.executeWithFlags(p_sql, 0);
    }

    @Override
    public boolean executeWithFlags(String sql, int flags) throws SQLException {
        return this.executeCachedSql(sql, flags, NO_RETURNING_COLUMNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCachedSql(String sql, int flags, String[] columnNames) throws SQLException {
        boolean res;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        boolean shouldUseParameterized = false;
        QueryExecutor queryExecutor = this.connection.getQueryExecutor();
        Object key = queryExecutor.createQueryKey(sql, this.replaceProcessingEnabled, shouldUseParameterized, columnNames);
        boolean shouldCache = preferQueryMode == PreferQueryMode.EXTENDED_CACHE_EVERYTING;
        CachedQuery cachedQuery = shouldCache ? queryExecutor.borrowQueryByKey(key) : queryExecutor.createQueryByKey(key);
        if (this.wantsGeneratedKeysOnce) {
            SqlCommand sqlCommand = cachedQuery.query.getSqlCommand();
            this.wantsGeneratedKeysOnce = sqlCommand != null && sqlCommand.isReturningKeywordPresent();
        }
        try {
            res = this.executeWithFlags(cachedQuery, flags);
        }
        finally {
            if (shouldCache) {
                queryExecutor.releaseQuery(cachedQuery);
            }
        }
        return res;
    }

    @Override
    public boolean executeWithFlags(CachedQuery simpleQuery, int flags) throws SQLException {
        this.checkClosed();
        if (this.connection.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) < 0) {
            flags |= 0x400;
        }
        this.execute(simpleQuery, null, flags);
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        this.checkClosed();
        throw new KSQLException(GT.tr("Can''t use executeWithFlags(int) on a Statement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    protected void closeForNextExecution() throws SQLException {
        this.clearWarnings();
        while (this.firstUnclosedResult != null) {
            ResultSet rs = this.firstUnclosedResult.getResultSet();
            if (rs != null) {
                rs.close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        this.result = null;
        if (this.generatedKeys != null) {
            if (this.generatedKeys.getResultSet() != null) {
                this.generatedKeys.getResultSet().close();
            }
            this.generatedKeys = null;
        }
    }

    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            return true;
        }
        cachedQuery.increaseExecuteCount();
        return (this.m_prepareThreshold == 0 || cachedQuery.getExecuteCount() < this.m_prepareThreshold) && !this.getForceBinaryTransfer();
    }

    protected final void execute(CachedQuery cachedQuery, ParameterList queryParameters, int flags) throws SQLException {
        try {
            this.executeInternal(cachedQuery, queryParameters, flags);
        }
        catch (SQLException e) {
            if (cachedQuery.query.getSubqueries() != null || !this.connection.getQueryExecutor().willHealOnRetry(e)) {
                throw e;
            }
            cachedQuery.query.close();
            this.executeInternal(cachedQuery, queryParameters, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(CachedQuery cachedQuery, ParameterList queryParameters, int flags) throws SQLException {
        this.closeForNextExecution();
        if (this.fetchSize > 0 && !this.wantsScrollableResultSet() && !this.wantsHoldableResultSet()) {
            flags |= 8;
        }
        if ((this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) && ((flags |= 0x40) & 4) != 0) {
            flags &= 0xFFFFFFFB;
        }
        if (this.isOneShotQuery(cachedQuery)) {
            flags |= 1;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        if (this.concurrency != 1007) {
            flags |= 0x100;
        }
        this.queryToExecute = cachedQuery.query;
        if (this.queryToExecute.isEmpty()) {
            flags |= 0x10;
        }
        if (!this.queryToExecute.isStatementDescribed() && this.forceBinaryTransfers && (flags & 0x400) == 0) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            this.connection.getQueryExecutor().execute(this.queryToExecute, queryParameters, handler2, 0, 0, flags2);
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        StatementResultHandler handler = new StatementResultHandler();
        this.result = null;
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(this.queryToExecute, queryParameters, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
        }
        i = 0;
        this.result = this.firstUnclosedResult = handler.getResults();
        if (this.fetchSize > 0 && (flags & 0x10) != 0 && (flags & 8) != 0) {
            if (this.queryToExecute.getSubqueries() == null) {
                if (((SimpleQuery)this.queryToExecute).isNeedNextResult()) {
                    this.result = this.result.getNext();
                }
            } else if (((SimpleQuery)this.queryToExecute.getSubqueries()[0]).isNeedNextResult()) {
                this.result = this.result.getNext();
            }
        }
        if (this.wantsGeneratedKeysOnce || this.wantsGeneratedKeysAlways) {
            this.generatedKeys = this.result;
            this.result = this.result.getNext();
            if (this.wantsGeneratedKeysOnce) {
                this.wantsGeneratedKeysOnce = false;
            }
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.result == null || this.result.getResultSet() != null) {
            return -1;
        }
        return this.result.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        if (this.fetchSize > 0 && this.connection.getAutoCommit() && !this.wantsScrollableResultSet() && !this.wantsHoldableResultSet() && this.queryToExecute.getSubqueries() != null && ++i < this.queryToExecute.getSubqueries().length && ((SimpleQuery)this.queryToExecute.getSubqueries()[i]).isNeedNextResult()) {
            this.result = this.result.getNext();
        }
        while (this.firstUnclosedResult != this.result) {
            if (this.firstUnclosedResult.getResultSet() != null) {
                this.firstUnclosedResult.getResultSet().close();
            }
            this.firstUnclosedResult = this.firstUnclosedResult.getNext();
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new KSQLException(GT.tr("Maximum number of rows must be a value grater than or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxrows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.replaceProcessingEnabled = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getQueryTimeoutMs() / 1000;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.setQueryTimeoutMs(seconds * 1000);
    }

    public int getQueryTimeoutMs() throws SQLException {
        this.checkClosed();
        return this.timeout;
    }

    public void setQueryTimeoutMs(int millis) throws SQLException {
        this.checkClosed();
        if (millis < 0) {
            throw new KSQLException(GT.tr("Query timeout must be a value greater than or equals to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.timeout = millis;
    }

    public void addWarning(SQLWarning warn) {
        if (this.warnings == null) {
            this.warnings = warn;
            this.lastWarning = warn;
        } else {
            this.lastWarning.setNextWarning(warn);
            this.lastWarning = warn;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw new KSQLException(GT.tr("The maximum field size must be a value greater than or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.maxfieldSize = max;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
        this.lastWarning = null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return null;
        }
        return this.result.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.cleanupTimer();
        this.closeForNextExecution();
        this.isClosed = true;
    }

    @Override
    public long getLastOID() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return 0L;
        }
        return this.result.getInsertOID();
    }

    @Override
    public void setPrepareThreshold(int newThreshold) throws SQLException {
        this.checkClosed();
        if (newThreshold < 0) {
            this.forceBinaryTransfers = true;
            newThreshold = 1;
        }
        this.m_prepareThreshold = newThreshold;
    }

    @Override
    public int getPrepareThreshold() {
        return this.m_prepareThreshold;
    }

    @Override
    public void setUseServerPrepare(boolean flag) throws SQLException {
        this.setPrepareThreshold(flag ? 1 : 0);
    }

    @Override
    public boolean isUseServerPrepare() {
        return false;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new KSQLException(GT.tr("This statement has been closed.", new Object[0]), KSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    @Override
    public void addBatch(String p_sql) throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        boolean shouldUseParameterized = false;
        CachedQuery cachedQuery = this.connection.createQuery(p_sql, this.replaceProcessingEnabled, shouldUseParameterized, new String[0]);
        this.batchStatements.add(cachedQuery.query);
        this.batchParameters.add(null);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchStatements != null) {
            this.batchStatements.clear();
            this.batchParameters.clear();
        }
    }

    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new BatchResultHandler(this, queries, parameterLists, this.wantsGeneratedKeysAlways);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        boolean sameQueryAhead;
        this.checkClosed();
        this.closeForNextExecution();
        if (this.batchStatements == null || this.batchStatements.isEmpty() || this.batchParameters == null) {
            return new int[0];
        }
        this.transformQueriesAndParameters();
        Query[] queries = this.batchStatements.toArray(new Query[0]);
        ParameterList[] parameterLists = this.batchParameters.toArray(new ParameterList[0]);
        this.batchStatements.clear();
        this.batchParameters.clear();
        int flags = 0;
        boolean preDescribe = false;
        flags = this.wantsGeneratedKeysAlways ? 320 : 4;
        PreferQueryMode preferQueryMode = this.connection.getPreferQueryMode();
        if (preferQueryMode == PreferQueryMode.SIMPLE || preferQueryMode == PreferQueryMode.EXTENDED_FOR_PREPARED && parameterLists[0] == null) {
            flags |= 0x400;
        }
        boolean bl = sameQueryAhead = queries.length > 1 && queries[0] == queries[1];
        if (!sameQueryAhead || this.isOneShotQuery(null)) {
            flags |= 1;
        } else {
            preDescribe = (this.wantsGeneratedKeysAlways || sameQueryAhead) && !queries[0].isStatementDescribed();
            flags |= 0x200;
        }
        if (this.connection.getAutoCommit()) {
            flags |= 0x10;
        }
        BatchResultHandler handler = this.createBatchHandler(queries, parameterLists);
        if ((preDescribe || this.forceBinaryTransfers) && (flags & 0x400) == 0) {
            int flags2 = flags | 0x20;
            StatementResultHandler handler2 = new StatementResultHandler();
            try {
                this.connection.getQueryExecutor().execute(queries[0], parameterLists[0], handler2, 0, 0, flags2);
            }
            catch (SQLException e) {
                handler.handleError(e);
                handler.handleCompletion();
            }
            ResultWrapper result2 = handler2.getResults();
            if (result2 != null) {
                result2.getResultSet().close();
            }
        }
        this.result = null;
        try {
            this.startTimer();
            this.connection.getQueryExecutor().execute(queries, parameterLists, handler, this.maxrows, this.fetchSize, flags);
        }
        finally {
            this.killTimerTask();
            if (this.wantsGeneratedKeysAlways) {
                this.generatedKeys = new ResultWrapper(handler.getGeneratedKeys());
            }
        }
        return handler.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        BaseConnection baseConnection;
        if (!STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.CANCELING)) {
            return;
        }
        try {
            baseConnection = this.connection;
            synchronized (baseConnection) {
                this.connection.cancelQuery();
            }
        }
        finally {
            STATE_UPDATER.set(this, StatementCancelState.CANCELLED);
            baseConnection = this.connection;
            synchronized (baseConnection) {
                this.connection.notifyAll();
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchdirection;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultsettype;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchdirection = direction;
                break;
            }
            default: {
                throw new KSQLException(GT.tr("Invalid fetch direction constant: {0}.", direction), KSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new KSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    private void startTimer() {
        this.cleanupTimer();
        STATE_UPDATER.set(this, StatementCancelState.IN_QUERY);
        if (this.timeout == 0) {
            return;
        }
        TimerTask cancelTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!CANCEL_TIMER_UPDATER.compareAndSet(KbStatement.this, this, null)) {
                        return;
                    }
                    KbStatement.this.cancel();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        CANCEL_TIMER_UPDATER.set(this, cancelTask);
        this.connection.addTimerTask(cancelTask, this.timeout);
    }

    private boolean cleanupTimer() {
        TimerTask timerTask = CANCEL_TIMER_UPDATER.get(this);
        if (timerTask == null) {
            return this.timeout == 0;
        }
        if (!CANCEL_TIMER_UPDATER.compareAndSet(this, timerTask, null)) {
            return false;
        }
        timerTask.cancel();
        this.connection.purgeTimerTasks();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killTimerTask() {
        boolean timerTaskIsClear = this.cleanupTimer();
        if (timerTaskIsClear && STATE_UPDATER.compareAndSet(this, StatementCancelState.IN_QUERY, StatementCancelState.IDLE)) {
            return;
        }
        boolean interrupted = false;
        while (!STATE_UPDATER.compareAndSet(this, StatementCancelState.CANCELLED, StatementCancelState.IDLE)) {
            BaseConnection baseConnection = this.connection;
            synchronized (baseConnection) {
                try {
                    this.connection.wait(10L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected boolean getForceBinaryTransfer() {
        return this.forceBinaryTransfers;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeUpdateCount");
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setLargeMaxRows");
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeBatch");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    public long executeLargeUpdate() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeLargeUpdate");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return this.poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    protected void checkCompletion() throws SQLException {
        if (!this.closeOnCompletion) {
            return;
        }
        for (ResultWrapper result = this.firstUnclosedResult; result != null; result = result.getNext()) {
            if (result.getResultSet() == null || result.getResultSet().isClosed()) continue;
            return;
        }
        this.closeOnCompletion = false;
        try {
            this.close();
        }
        finally {
            this.closeOnCompletion = true;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current == 1 && this.result != null && this.result.getResultSet() != null) {
            this.result.getResultSet().close();
        }
        if (this.result != null) {
            this.result = this.result.getNext();
        }
        if (current == 3) {
            while (this.firstUnclosedResult != this.result) {
                if (this.firstUnclosedResult.getResultSet() != null) {
                    this.firstUnclosedResult.getResultSet().close();
                }
                this.firstUnclosedResult = this.firstUnclosedResult.getNext();
            }
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.generatedKeys == null || this.generatedKeys.getResultSet() == null) {
            return this.createDriverResultSet(new Field[0], new ArrayList<byte[][]>());
        }
        return this.generatedKeys.getResultSet();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        return this.executeUpdate(sql, (String[])null);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            return this.executeUpdate(sql);
        }
        throw new KSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.executeUpdate(sql);
        }
        this.wantsGeneratedKeysOnce = true;
        if (!this.executeCachedSql(sql, 0, columnNames)) {
            // empty if block
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        return this.execute(sql, (String[])null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.execute(sql);
        }
        throw new KSQLException(GT.tr("Returning autogenerated keys by column index is not supported.", new Object[0]), KSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.execute(sql);
        }
        this.wantsGeneratedKeysOnce = true;
        return this.executeCachedSql(sql, 0, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public ResultSet createDriverResultSet(Field[] fields, List<byte[][]> tuples) throws SQLException {
        return this.createResultSet(null, fields, tuples, null);
    }

    protected void transformQueriesAndParameters() throws SQLException {
    }

    public class StatementResultHandler
    extends ResultHandlerBase {
        private ResultWrapper results;
        private ResultWrapper lastResult;

        ResultWrapper getResults() {
            return this.results;
        }

        private void append(ResultWrapper newResult) {
            if (this.results == null) {
                this.lastResult = this.results = newResult;
            } else {
                this.lastResult.append(newResult);
            }
        }

        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
            try {
                ResultSet rs = KbStatement.this.createResultSet(fromQuery, fields, tuples, cursor);
                this.append(new ResultWrapper(rs));
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.append(new ResultWrapper(updateCount, insertOID));
        }

        @Override
        public void handleCompletion() throws SQLException {
            super.handleCompletion();
        }

        @Override
        public void handleWarning(SQLWarning warning) {
            if (KbStatement.this.warnings == null) {
                KbStatement.this.warnings = warning;
                KbStatement.this.lastWarning = warning;
            }
            super.handleWarning(warning);
        }
    }
}

