package org.beetl.sql.core;

import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.TableDesc;

import java.util.Map;

/**
 * 内置的SQLSource，如CRUD
 * @author xiandafu
 *
 */
public class SQLTableSource extends SQLSource {
	
	
	protected TableDesc tableDesc;
	
	protected Map<String,AssignID> assignIds;
	protected int idType;
	
	public SQLTableSource(String template) {

		this.template = template;
	}
	
	public SQLTableSource() {

	}

	public SQLTableSource(String template, SQLType sqlType) {

		this.template = template;
		this.sqlType = sqlType;
		this.isAutoGenerated=true;
	}
	
	

	public int getIdType() {
		return idType;
	}

	public void setIdType(int idType) {
		this.idType = idType;
	}

	

	public TableDesc getTableDesc() {
		return tableDesc;
	}

	public void setTableDesc(TableDesc tableDesc) {
		this.tableDesc = tableDesc;
	}

	public Map<String, AssignID> getAssignIds() {
		return assignIds;
	}

	public void setAssignIds(Map<String, AssignID> assignIds) {
		this.assignIds = assignIds;
	}


	
}
