package org.beetl.sql.core.db;

import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.SQLSource;

/**
 * 根据实体自动生成crud 的sql
 */
public interface DBAutoGeneratedSql {

    String OFFSET = "_pageOffset";
    String PAGE_SIZE = "_pageSize";
    String PAGE_END = "_pageEnd";
    String ORDER_BY = "_orderBy";
    String PAGE = "_page";

    NameConversion getNameConversion();

    void setNameConversion(NameConversion nameConversion);

    SQLSource genSelectById(Class<?> cls,Class viewType);

    SQLSource genSelectByIds(Class<?> cls,Class viewType);

    SQLSource genExistSql(Class<?> cls);

    SQLSource genSelectByIdForUpdate(Class<?> cls,Class viewType);

    SQLSource genSelectByTemplate(Class<?> cls,Class viewType);

    SQLSource genSelectCountByTemplate(Class<?> cls);

    SQLSource genDeleteById(Class<?> cls);

    SQLSource genSelectAll(Class<?> cls,Class viewType);

    SQLSource genUpdateAll(Class<?> cls);

    SQLSource genUpdateById(Class<?> cls);

    SQLSource genUpdateAbsolute(Class<?> cls);

    SQLSource genUpdateTemplate(Class<?> cls);

    SQLSource genInsert(Class<?> cls);

    SQLSource genInsertTemplate(Class<?> cls);

}
