<?php
namespace app\home\controller;
use think\Lang;
/**
 * ============================================================================
 * DSMall多用户商城
 * ============================================================================
 * 版权所有 2014-2028 长沙德尚网络科技有限公司，并保留所有权利。
 * 网站地址: http://www.csdeshang.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和使用 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 控制器
 */
class  Memberinviter extends BaseMember {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/memberinviter.lang.php');
        if(!config('inviter_open')){
            $this->error(lang('inviter_not_open'));
        }
    }

    public function add(){
        //判断是否已是分销员
        $inviter_model=model('inviter');
        $inviter_info=$inviter_model->getInviterInfo('i.inviter_id='.session('member_id'));
        
        if($inviter_info && $inviter_info['inviter_state']==0){
            $this->error(lang('inviter_view'));
        }
        if($inviter_info && $inviter_info['inviter_state']==2){
            $this->error(lang('inviter_close'));
        }
        if($inviter_info && $inviter_info['inviter_state']==1){
            $this->redirect('Home/Memberinviter/index');
        }
        //是否有分销门槛
        if(config('inviter_condition')){
            //检查消费金额
            $vrorder_amount=db('vrorder')->where('buyer_id='.session('member_id').' AND order_state='.ORDER_STATE_SUCCESS)->sum('order_amount-refund_amount');
            if($vrorder_amount<config('inviter_condition_amount')){
                $this->error(sprintf(lang('inviter_condition_amount'),$vrorder_amount,config('inviter_condition_amount')));
            }
            
        }
        $inviter_model->addInviter(array(
            'inviter_id'=>session('member_id'),
            'inviter_state'=>config('inviter_view')?0:1,
            'inviter_applytime'=>TIMESTAMP,
        ));
        if(config('inviter_view')){
            $this->redirect('Home/Memberinviter/add');
        }else{
            $this->redirect('Home/Memberinviter/index');
        }
        
    }
    /**
     * 推广海报【会员推广】
     *
     * @param
     * @return
     */
    public function index() {
        $member_info = $this->member_info;
        $this->assign('inviter_url',HOME_SITE_URL.'/Login/register.html?inviter_id=' . $member_info['member_id']);
        
        //生成微信推广二维码
        $inviter_model=model('inviter');
        $qrcode_weixin = $inviter_model->qrcode_weixin($member_info);
        $this->assign('wx_error_msg',$qrcode_weixin['wx_error_msg']);
        $this->assign('refer_qrcode_weixin',$qrcode_weixin['refer_qrcode_weixin']);
        
        //生成URL推广二维码
        $inviter_model->qrcode_logo($member_info);
        

        $this->assign('refer_qrcode_logo',UPLOAD_SITE_URL. '/' . ATTACH_INVITER . '/' . $member_info['member_id'] . '_poster.png');
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('inviter_poster');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('poster');
        return $this->fetch($this->template_dir . 'index');
    }
    
    public function user(){
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('inviter_user');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('user');
        $member_model = model('member');
        $conditions=array('inviter_id'=>$this->member_info['member_id']);
        if(input('param.member_name')){
            $conditions['member_name']=array('like','%'.input('param.member_name').'%');
        }
        $member_list=$member_model->getMemberList($conditions, 'member_id,member_name,member_avatar,member_addtime,member_logintime', 10, 'member_id desc');
        if(is_array($member_list)){
            foreach($member_list as $key => $val){
                $member_list[$key]['member_addtime'] = $val['member_addtime'] ? date('Y-m-d H:i:s', $val['member_addtime']) : '';
                $member_list[$key]['member_logintime'] = $val['member_logintime'] ? date('Y-m-d H:i:s', $val['member_logintime']) : '';
                //该会员的2级内推荐会员
                $member_list[$key]['inviters']=array();
                $inviter_1=db('member')->where('inviter_id',$val['member_id'])->field('member_id,member_name')->find();
                if($inviter_1){
                    $member_list[$key]['inviters'][]=$inviter_1['member_name'];
                    $inviter_2=db('member')->where('inviter_id',$inviter_1['member_id'])->field('member_id,member_name')->find();
                    if($inviter_2){
                        $member_list[$key]['inviters'][]=$inviter_2['member_name'];
                    }
                }
                
            }
        }
        $this->assign('member_list', $member_list);
        $this->assign('show_page', $member_model->page_info->render());
        return $this->fetch($this->template_dir . 'user');
    }
    
    public function order(){
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('inviter_order');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('order');

        $conditions=array('orderinviter_member_id'=> $this->member_info['member_id']);
        if(input('param.orderinviter_order_sn')){
            $conditions['orderinviter_order_sn']=array('like','%'.input('param.orderinviter_order_sn').'%');
        }
        $orderinviter_list = db('orderinviter')->where($conditions)->order('orderinviter_id desc')->paginate(10);
        $page = $orderinviter_list->render();
        $this->assign('show_page', $page);
        $this->assign('orderinviter_list', $orderinviter_list);
        return $this->fetch($this->template_dir . 'order');
    }
    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    public function getMemberItemList() {
        $menu_array = array(
            array(
                'name' => 'poster',
                'text' => lang('inviter_poster'),
                'url' => url('Memberinviter/index')
            ),
            array(
                'name' => 'user',
                'text' => lang('inviter_user'),
                'url' => url('Memberinviter/user')
            ),
            array(
                'name' => 'order',
                'text' => lang('inviter_order'),
                'url' => url('Memberinviter/order')
            ),
        );

        return $menu_array;
    }

}
